/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link KanbanControlCycleV2ServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service KanbanControlCycleV2Service},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultKanbanControlCycleV2ServiceBatch
    extends
    BatchFluentHelperBasic<KanbanControlCycleV2ServiceBatch, KanbanControlCycleV2ServiceBatchChangeSet>
    implements
    KanbanControlCycleV2ServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultKanbanControlCycleV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultKanbanControlCycleV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultKanbanControlCycleV2ServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultKanbanControlCycleV2ServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultKanbanControlCycleV2ServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public KanbanControlCycleV2ServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultKanbanControlCycleV2ServiceBatchChangeSet(this, service);
    }

}
