/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle;

/**
 * Implementation of the {@link KanbanControlCycleV2ServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service KanbanControlCycleV2Service}.
 *
 */
public class DefaultKanbanControlCycleV2ServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<KanbanControlCycleV2ServiceBatch, KanbanControlCycleV2ServiceBatchChangeSet>
    implements
    KanbanControlCycleV2ServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service service;

    @SuppressWarnings( "deprecation" )
    DefaultKanbanControlCycleV2ServiceBatchChangeSet(
        @Nonnull final DefaultKanbanControlCycleV2ServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultKanbanControlCycleV2ServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public KanbanControlCycleV2ServiceBatchChangeSet createKanbanControlCycle(
        @Nonnull final KanbanControlCycle kanbanControlCycle )
    {
        return addRequestCreate(service::createKanbanControlCycle, kanbanControlCycle);
    }

    @Nonnull
    @Override
    public KanbanControlCycleV2ServiceBatchChangeSet updateKanbanControlCycle(
        @Nonnull final KanbanControlCycle kanbanControlCycle )
    {
        return addRequestUpdate(service::updateKanbanControlCycle, kanbanControlCycle);
    }

    @Nonnull
    @Override
    public KanbanControlCycleV2ServiceBatchChangeSet deleteKanbanControlCycle(
        @Nonnull final KanbanControlCycle kanbanControlCycle )
    {
        return addRequestDelete(service::deleteKanbanControlCycle, kanbanControlCycle);
    }

}
