/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.KanbanControlCycleV2Service
 * KanbanControlCycleV2Service}.
 *
 */
public interface KanbanControlCycleV2ServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<KanbanControlCycleV2ServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<KanbanControlCycleV2ServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     * KanbanControlCycle} entity and save it to the S/4HANA system.
     *
     * @param kanbanControlCycle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *            KanbanControlCycle} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    KanbanControlCycleV2ServiceBatchChangeSet
        createKanbanControlCycle( @Nonnull final KanbanControlCycle kanbanControlCycle );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     * KanbanControlCycle} entity and save it to the S/4HANA system.
     *
     * @param kanbanControlCycle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *            KanbanControlCycle} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    KanbanControlCycleV2ServiceBatchChangeSet
        updateKanbanControlCycle( @Nonnull final KanbanControlCycle kanbanControlCycle );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     * KanbanControlCycle} entity in the S/4HANA system.
     *
     * @param kanbanControlCycle
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
     *            KanbanControlCycle} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    KanbanControlCycleV2ServiceBatchChangeSet
        deleteKanbanControlCycle( @Nonnull final KanbanControlCycle kanbanControlCycle );

}
