/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer KanbanContainer}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.field.KanbanContainerField
 * KanbanContainerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.link.KanbanContainerLink
 * KanbanContainerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#KANBAN_CONTAINER
 * KANBAN_CONTAINER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#KANBAN_CONTROL_CYCLE
 * KANBAN_CONTROL_CYCLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#KANBAN_CONTROL_CYCLE_ITEM
 * KANBAN_CONTROL_CYCLE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PRODUCTION_SUPPLY_AREA
 * PRODUCTION_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#KANBAN_CONTAINER_STATUS
 * KANBAN_CONTAINER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#IS_LOCKED
 * IS_LOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#LAST_CHANGE_TIME
 * LAST_CHANGE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PLANNED_ORDER
 * PLANNED_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#SALES_DOCUMENT
 * SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#SALES_DOCUMENT_ITEM
 * SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#REPETITIVE_MFG_CONFIRMATION
 * REPETITIVE_MFG_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#MATERIAL_DOCUMENT
 * MATERIAL_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#MATERIAL_DOCUMENT_YEAR
 * MATERIAL_DOCUMENT_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#MATERIAL_DOCUMENT_ITEM
 * MATERIAL_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#ACTUAL_QUANTITY_IN_BASE_UNIT
 * ACTUAL_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#REQUESTED_QUANTITY_IN_BASE_UNIT
 * REQUESTED_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PREVIOUS_LAST_CHANGE_DATE
 * PREVIOUS_LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PREVIOUS_LAST_CHANGE_TIME
 * PREVIOUS_LAST_CHANGE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#TRANSFER_REQUIREMENT_NUMBER
 * TRANSFER_REQUIREMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#TRANSFER_REQUIREMENT_ITEM
 * TRANSFER_REQUIREMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PREVIOUS_KANBAN_CONTAINER_STATUS
 * PREVIOUS_KANBAN_CONTAINER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#INTERNAL_JIT_CALL_NUMBER
 * INTERNAL_JIT_CALL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#JIT_CALL_ITEM_NUMBER
 * JIT_CALL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PLANNED_RECEIPT_DATE_TIME
 * PLANNED_RECEIPT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#CHANGED_PACKG_INSTRN_DATA_IS_AVAIL
 * CHANGED_PACKG_INSTRN_DATA_IS_AVAIL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#SEQUENTIAL_NMBR_OF_SUPLR_CONF
 * SEQUENTIAL_NMBR_OF_SUPLR_CONF}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#BACKFLUSH_REPORTING_POINT
 * BACKFLUSH_REPORTING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PURCHASING_DOCUMENT_CATEGORY
 * PURCHASING_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#WAREHOUSE_TASK
 * WAREHOUSE_TASK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#WHSE_GOODS_MOVEMENT_DOCUMENT
 * WHSE_GOODS_MOVEMENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#WHSE_GOODS_MOVEMENT_DOCUMENT_ITEM
 * WHSE_GOODS_MOVEMENT_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#PLANT_TIME_ZONE
 * PLANT_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#TO_KANBAN_CTN_DETAILED_QTY
 * TO_KANBAN_CTN_DETAILED_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#TO_KANBAN_DELIVERY
 * TO_KANBAN_DELIVERY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanContainer#TO_KANBAN_CONTROL_CYCLE
 * TO_KANBAN_CONTROL_CYCLE}</li>
 * </ul>
 *
 */
public interface KanbanContainerSelectable extends EntitySelectable<KanbanContainer>
{

}
