/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle
 * KanbanControlCycle}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.field.KanbanControlCycleField
 * KanbanControlCycleField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.link.KanbanControlCycleLink
 * KanbanControlCycleLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CONTROL_CYCLE
 * KANBAN_CONTROL_CYCLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CONTROL_CYCLE_CATEGORY
 * KANBAN_CONTROL_CYCLE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PRODUCTION_VERSION
 * PRODUCTION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PRODUCTION_SUPPLY_AREA
 * PRODUCTION_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#SUPPLY_SOURCE_RESPONSIBLE_PERSON
 * SUPPLY_SOURCE_RESPONSIBLE_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#STORING_POSITION_NAME
 * STORING_POSITION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CONTAINER_DELIVERY_ADDRESS
 * KANBAN_CONTAINER_DELIVERY_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PRODUCT_COST_COLLECTOR
 * PRODUCT_COST_COLLECTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PURCHASE_OUTLINE_AGREEMENT
 * PURCHASE_OUTLINE_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PURCHASE_OUTLINE_AGREEMENT_ITEM
 * PURCHASE_OUTLINE_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#STORAGE_TYPE
 * STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#STORAGE_BIN
 * STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CONTAINER_QUANTITY_IN_BS_UNT
 * KANBAN_CONTAINER_QUANTITY_IN_BS_UNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#NUMBER_OF_KANBAN_CONTAINERS
 * NUMBER_OF_KANBAN_CONTAINERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#MAX_NR_OF_EMPTY_KANBAN_CONTAINERS
 * MAX_NR_OF_EMPTY_KANBAN_CONTAINERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#IN_HOUSE_PRODUCTION_REPLNMT_STRGY
 * IN_HOUSE_PRODUCTION_REPLNMT_STRGY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#MATERIAL_STAGING
 * MATERIAL_STAGING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#DESTINATION_BIN_IS_DYNAMIC
 * DESTINATION_BIN_IS_DYNAMIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#EXT_PROCUREMENT_REPLNMT_STRGY
 * EXT_PROCUREMENT_REPLNMT_STRGY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#STOCK_TRANSFER_REPLNMT_STRATEGY
 * STOCK_TRANSFER_REPLNMT_STRATEGY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#REPLNMT_IS_CTRLD_BY_SUPPLY_SOURCE
 * REPLNMT_IS_CTRLD_BY_SUPPLY_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CONTAINER_PACKGG_PRODUCT
 * KANBAN_CONTAINER_PACKGG_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#SEPARATE_GR_IS_NEEDED_IF_SET_TO_FULL
 * SEPARATE_GR_IS_NEEDED_IF_SET_TO_FULL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#SUPPLY_SOURCE_PLANT
 * SUPPLY_SOURCE_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CONTAINER_STATUS_SEQUENCE
 * KANBAN_CONTAINER_STATUS_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_REPLNMT_TRIGGER_LOGIC
 * KANBAN_CTN_REPLNMT_TRIGGER_LOGIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KNBN_CTN_REPLNMT_TRGGR_QTY_IN_BS_UNT
 * KNBN_CTN_REPLNMT_TRGGR_QTY_IN_BS_UNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CONTAINER_CALCULATION_TYPE
 * KANBAN_CONTAINER_CALCULATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_CALC_SAFETY_FACTOR
 * KANBAN_CTN_CALC_SAFETY_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_CALCULATION_CONSTANT
 * KANBAN_CTN_CALCULATION_CONSTANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_ROUNDING_QTY_IN_BS_UNT
 * KANBAN_CTN_ROUNDING_QTY_IN_BS_UNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#FIXED_KANBAN_CONTAINER_QTY_IN_BS_UNT
 * FIXED_KANBAN_CONTAINER_QTY_IN_BS_UNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CONTAINER_CALC_PROFILE
 * KANBAN_CONTAINER_CALC_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#REPLNMT_LEAD_TIME_IN_WORKDAYS
 * REPLNMT_LEAD_TIME_IN_WORKDAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#REPLNMT_LEAD_TIME_IN_MINUTES
 * REPLNMT_LEAD_TIME_IN_MINUTES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#SALES_SCHEDULING_AGREEMENT
 * SALES_SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#SALES_SCHEDULING_AGREEMENT_ITEM
 * SALES_SCHEDULING_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#SOURCE_PRODUCTION_SUPPLY_AREA
 * SOURCE_PRODUCTION_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#JIT_CALL_PROFILE
 * JIT_CALL_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PACKING_INSTRUCTION
 * PACKING_INSTRUCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#NUMBER_OF_LOAD_CARRIERS
 * NUMBER_OF_LOAD_CARRIERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#BACKFLUSH_REPORTING_POINT
 * BACKFLUSH_REPORTING_POINT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTRL_CYCLE_LIFE_CYCLE_STATUS
 * KANBAN_CTRL_CYCLE_LIFE_CYCLE_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#RELEASE_DATE
 * RELEASE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#LOCK_DATE
 * LOCK_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PULL_INTERVAL_IN_WORKDAYS
 * PULL_INTERVAL_IN_WORKDAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PULL_INTERVAL_IN_MINUTES
 * PULL_INTERVAL_IN_MINUTES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_REFILL_TIME_IN_DAYS
 * KANBAN_CTN_REFILL_TIME_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_REFILL_TME_IN_MINUTES
 * KANBAN_CTN_REFILL_TME_IN_MINUTES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_WAIT_TIME_IN_DAYS
 * KANBAN_CTN_WAIT_TIME_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_WAIT_TIME_IN_MINUTES
 * KANBAN_CTN_WAIT_TIME_IN_MINUTES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_TRANSPORT_TIME_IN_DAYS
 * KANBAN_CTN_TRANSPORT_TIME_IN_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTN_TRANSPORT_TME_IN_MINUTES
 * KANBAN_CTN_TRANSPORT_TME_IN_MINUTES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KNBN_CTN_CALC_RQMT_BUFFER_IN_PERCENT
 * KNBN_CTN_CALC_RQMT_BUFFER_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KNBN_CTN_CALC_SUPPLY_SRCE_BUF_IN_PCT
 * KNBN_CTN_CALC_SUPPLY_SRCE_BUF_IN_PCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#NR_OF_KANBAN_CTNS_FLAGGED_TO_UNLOCK
 * NR_OF_KANBAN_CTNS_FLAGGED_TO_UNLOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#NR_OF_WAITING_KNBN_CTNS_BFR_REPLNMT
 * NR_OF_WAITING_KNBN_CTNS_BFR_REPLNMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#KANBAN_CTRL_CYC_REPLNMT_TRIGGER_GRP
 * KANBAN_CTRL_CYC_REPLNMT_TRIGGER_GRP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PLANNING_WORK_CENTER
 * PLANNING_WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#PRODUCTION_ORDERS_ARE_COMBINED
 * PRODUCTION_ORDERS_ARE_COMBINED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#DESTINATION_STORAGE_BIN
 * DESTINATION_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#SOURCE_STORAGE_BIN
 * SOURCE_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#WAREHOUSE_PROCESS_TYPE
 * WAREHOUSE_PROCESS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#TO_KANBAN_CONTAINER
 * TO_KANBAN_CONTAINER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanControlCycle#TO_KANBAN_CONT_DELIVERY_ADDR
 * TO_KANBAN_CONT_DELIVERY_ADDR}</li>
 * </ul>
 *
 */
public interface KanbanControlCycleSelectable extends EntitySelectable<KanbanControlCycle>
{

}
