/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty
 * KanbanCtnDetailedQty}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.field.KanbanCtnDetailedQtyField
 * KanbanCtnDetailedQtyField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.link.KanbanCtnDetailedQtyLink
 * KanbanCtnDetailedQtyLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty#KANBAN_CONTAINER
 * KANBAN_CONTAINER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty#BATCH
 * BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty#ACTUAL_QUANTITY_IN_BASE_UNIT
 * ACTUAL_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanCtnDetailedQty#KANBAN_CONTROL_CYCLE
 * KANBAN_CONTROL_CYCLE}</li>
 * </ul>
 *
 */
public interface KanbanCtnDetailedQtySelectable extends EntitySelectable<KanbanCtnDetailedQty>
{

}
