/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery KanbanDelivery}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.field.KanbanDeliveryField
 * KanbanDeliveryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.link.KanbanDeliveryLink
 * KanbanDeliveryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#KANBAN_CONTAINER
 * KANBAN_CONTAINER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#CUSTOMER_REFERENCE_NUMBER
 * CUSTOMER_REFERENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#DELIVERY_DOCUMENT
 * DELIVERY_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#DELIVERY_DOCUMENT_ITEM
 * DELIVERY_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#KANBAN_CONTROL_CYCLE
 * KANBAN_CONTROL_CYCLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#TO_KANBAN_CONTAINER
 * TO_KANBAN_CONTAINER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.kanbancontrolcyclev2.KanbanDelivery#TO_KANBAN_CONTROL_CYCLE
 * TO_KANBAN_CONTROL_CYCLE}</li>
 * </ul>
 *
 */
public interface KanbanDeliverySelectable extends EntitySelectable<KanbanDelivery>
{

}
