/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.field.LedgerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.link.LedgerLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.selectable.LedgerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Ledger
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LedgerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Ledger extends VdmEntity<Ledger>
{

    /**
     * Selector for all available fields of Ledger.
     *
     */
    public final static LedgerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger in General Ledger Accounting
     */
    @Key
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static LedgerField<String> LEDGER = new LedgerField<String>("Ledger");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLeadingLedger</b>
     * </p>
     *
     * @return Indicator: Leading Ledger
     */
    @SerializedName( "IsLeadingLedger" )
    @JsonProperty( "IsLeadingLedger" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsLeadingLedger" )
    private Boolean isLeadingLedger;
    /**
     * Use with available fluent helpers to apply the <b>IsLeadingLedger</b> field to query operations.
     *
     */
    public final static LedgerField<Boolean> IS_LEADING_LEDGER = new LedgerField<Boolean>("IsLeadingLedger");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LedgerApplication</b>
     * </p>
     *
     * @return Owner application
     */
    @SerializedName( "LedgerApplication" )
    @JsonProperty( "LedgerApplication" )
    @Nullable
    @ODataField( odataName = "LedgerApplication" )
    private String ledgerApplication;
    /**
     * Use with available fluent helpers to apply the <b>LedgerApplication</b> field to query operations.
     *
     */
    public final static LedgerField<String> LEDGER_APPLICATION = new LedgerField<String>("LedgerApplication");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LedgerSubApplication</b>
     * </p>
     *
     * @return Subapplication
     */
    @SerializedName( "LedgerSubApplication" )
    @JsonProperty( "LedgerSubApplication" )
    @Nullable
    @ODataField( odataName = "LedgerSubApplication" )
    private String ledgerSubApplication;
    /**
     * Use with available fluent helpers to apply the <b>LedgerSubApplication</b> field to query operations.
     *
     */
    public final static LedgerField<String> LEDGER_SUB_APPLICATION = new LedgerField<String>("LedgerSubApplication");
    /**
     * Navigation property <b>to_Text</b> for <b>Ledger</b> to multiple <b>LedgerText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LedgerText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static LedgerLink<LedgerText> TO_TEXT = new LedgerLink<LedgerText>("to_Text");

    @Nonnull
    @Override
    public Class<Ledger> getType()
    {
        return Ledger.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsLeadingLedger</b>
     * </p>
     *
     * @param isLeadingLedger
     *            Indicator: Leading Ledger
     */
    public void setIsLeadingLedger( @Nullable final Boolean isLeadingLedger )
    {
        rememberChangedField("IsLeadingLedger", this.isLeadingLedger);
        this.isLeadingLedger = isLeadingLedger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LedgerApplication</b>
     * </p>
     *
     * @param ledgerApplication
     *            Owner application
     */
    public void setLedgerApplication( @Nullable final String ledgerApplication )
    {
        rememberChangedField("LedgerApplication", this.ledgerApplication);
        this.ledgerApplication = ledgerApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LedgerSubApplication</b>
     * </p>
     *
     * @param ledgerSubApplication
     *            Subapplication
     */
    public void setLedgerSubApplication( @Nullable final String ledgerSubApplication )
    {
        rememberChangedField("LedgerSubApplication", this.ledgerSubApplication);
        this.ledgerSubApplication = ledgerSubApplication;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_Ledger";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Ledger", getLedger());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Ledger", getLedger());
        values.put("IsLeadingLedger", getIsLeadingLedger());
        values.put("LedgerApplication", getLedgerApplication());
        values.put("LedgerSubApplication", getLedgerSubApplication());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("IsLeadingLedger") ) {
                final Object value = values.remove("IsLeadingLedger");
                if( (value == null) || (!value.equals(getIsLeadingLedger())) ) {
                    setIsLeadingLedger(((Boolean) value));
                }
            }
            if( values.containsKey("LedgerApplication") ) {
                final Object value = values.remove("LedgerApplication");
                if( (value == null) || (!value.equals(getLedgerApplication())) ) {
                    setLedgerApplication(((String) value));
                }
            }
            if( values.containsKey("LedgerSubApplication") ) {
                final Object value = values.remove("LedgerSubApplication");
                if( (value == null) || (!value.equals(getLedgerSubApplication())) ) {
                    setLedgerSubApplication(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LedgerText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new LedgerText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LedgerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LedgerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LedgerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LedgerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>LedgerText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LedgerText</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LedgerText> fetchText()
    {
        return fetchFieldAsList("to_Text", LedgerText.class);
    }

    /**
     * Retrieval of associated <b>LedgerText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>Ledger</b> is operated lazily, an <b>ODataException</b>
     * can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LedgerText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LedgerText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>LedgerText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>Ledger</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>LedgerText</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<LedgerText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>LedgerText</b> entities for the loaded navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>Ledger</b> is operated lazily, an <b>ODataException</b>
     * can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LedgerText</b> entities.
     */
    public void setText( @Nonnull final List<LedgerText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LedgerText</b> entities. This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>Ledger</b> is operated lazily, an <b>ODataException</b>
     * can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LedgerText</b> entities.
     */
    public void addText( LedgerText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Ledger instances.
     *
     */
    public final static class LedgerBuilder
    {

        private List<LedgerText> toText = Lists.newArrayList();

        private Ledger.LedgerBuilder toText( final List<LedgerText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>Ledger</b> to multiple <b>LedgerText</b>.
         *
         * @param value
         *            The LedgerTexts to build this Ledger with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Ledger.LedgerBuilder text( LedgerText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
