/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.field.LedgerTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.link.LedgerTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.selectable.LedgerTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Ledger Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LedgerTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LedgerText extends VdmEntity<LedgerText>
{

    /**
     * Selector for all available fields of LedgerText.
     *
     */
    public final static LedgerTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger in General Ledger Accounting
     */
    @Key
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static LedgerTextField<String> LEDGER = new LedgerTextField<String>("Ledger");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static LedgerTextField<String> LANGUAGE = new LedgerTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>LedgerName</b>
     * </p>
     *
     * @return Ledger Name
     */
    @SerializedName( "LedgerName" )
    @JsonProperty( "LedgerName" )
    @Nullable
    @ODataField( odataName = "LedgerName" )
    private String ledgerName;
    /**
     * Use with available fluent helpers to apply the <b>LedgerName</b> field to query operations.
     *
     */
    public final static LedgerTextField<String> LEDGER_NAME = new LedgerTextField<String>("LedgerName");
    /**
     * Navigation property <b>to_Ledger</b> for <b>LedgerText</b> to single <b>Ledger</b>.
     *
     */
    @SerializedName( "to_Ledger" )
    @JsonProperty( "to_Ledger" )
    @ODataField( odataName = "to_Ledger" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Ledger toLedger;
    /**
     * Use with available fluent helpers to apply the <b>to_Ledger</b> navigation property to query operations.
     *
     */
    public final static LedgerTextOneToOneLink<Ledger> TO_LEDGER = new LedgerTextOneToOneLink<Ledger>("to_Ledger");

    @Nonnull
    @Override
    public Class<LedgerText> getType()
    {
        return LedgerText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>LedgerName</b>
     * </p>
     *
     * @param ledgerName
     *            Ledger Name
     */
    public void setLedgerName( @Nullable final String ledgerName )
    {
        rememberChangedField("LedgerName", this.ledgerName);
        this.ledgerName = ledgerName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LedgerText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Ledger", getLedger());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Ledger", getLedger());
        values.put("Language", getLanguage());
        values.put("LedgerName", getLedgerName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LedgerName") ) {
                final Object value = values.remove("LedgerName");
                if( (value == null) || (!value.equals(getLedgerName())) ) {
                    setLedgerName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Ledger") ) {
                final Object value = (values).remove("to_Ledger");
                if( value instanceof Map ) {
                    if( toLedger == null ) {
                        toLedger = new Ledger();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toLedger.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LedgerTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LedgerTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LedgerTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LedgerTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLedger != null ) {
            (values).put("to_Ledger", toLedger);
        }
        return values;
    }

    /**
     * Fetches the <b>Ledger</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Ledger</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Ledger</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Ledger fetchLedger()
    {
        return fetchFieldAsSingle("to_Ledger", Ledger.class);
    }

    /**
     * Retrieval of associated <b>Ledger</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Ledger</b>.
     * <p>
     * If the navigation property <b>to_Ledger</b> of a queried <b>LedgerText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Ledger</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Ledger getLedgerOrFetch()
    {
        if( toLedger == null ) {
            toLedger = fetchLedger();
        }
        return toLedger;
    }

    /**
     * Retrieval of associated <b>Ledger</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Ledger</b>.
     * <p>
     * If the navigation property for an entity <b>LedgerText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Ledger</b> is already loaded, the result will contain
     *         the <b>Ledger</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Ledger> getLedgerIfPresent()
    {
        return Option.of(toLedger);
    }

    /**
     * Overwrites the associated <b>Ledger</b> entity for the loaded navigation property <b>to_Ledger</b>.
     *
     * @param value
     *            New <b>Ledger</b> entity.
     */
    public void setLedger( final Ledger value )
    {
        toLedger = value;
    }

    /**
     * Helper class to allow for fluent creation of LedgerText instances.
     *
     */
    public final static class LedgerTextBuilder
    {

        private Ledger toLedger;
        private String ledger = null;

        private LedgerText.LedgerTextBuilder toLedger( final Ledger value )
        {
            toLedger = value;
            return this;
        }

        /**
         * Navigation property <b>to_Ledger</b> for <b>LedgerText</b> to single <b>Ledger</b>.
         *
         * @param value
         *            The Ledger to build this LedgerText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LedgerText.LedgerTextBuilder ledger( final Ledger value )
        {
            return toLedger(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 2
         * <p>
         * Original property name from the Odata EDM: <b>Ledger</b>
         * </p>
         *
         * @param value
         *            The ledger to build this LedgerText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LedgerText.LedgerTextBuilder ledger( final String value )
        {
            ledger = value;
            return this;
        }

    }

}
