/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link LedgerServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService LedgerService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultLedgerServiceBatch extends BatchFluentHelperBasic<LedgerServiceBatch, LedgerServiceBatchChangeSet>
    implements
    LedgerServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultLedgerServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLedgerServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultLedgerServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLedgerServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultLedgerServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LedgerServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultLedgerServiceBatchChangeSet(this, service);
    }

}
