/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link LedgerServiceBatchChangeSet} interface, enabling you to combine multiple operations into
 * one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService LedgerService}.
 *
 */
public class DefaultLedgerServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<LedgerServiceBatch, LedgerServiceBatchChangeSet>
    implements
    LedgerServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService service;

    @SuppressWarnings( "deprecation" )
    DefaultLedgerServiceBatchChangeSet(
        @Nonnull final DefaultLedgerServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LedgerService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultLedgerServiceBatchChangeSet getThis()
    {
        return this;
    }

}
