/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.Ledger;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.Ledger Ledger}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.field.LedgerField LedgerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.link.LedgerLink LedgerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.Ledger#LEDGER LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.Ledger#IS_LEADING_LEDGER
 * IS_LEADING_LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.Ledger#LEDGER_APPLICATION
 * LEDGER_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.Ledger#LEDGER_SUB_APPLICATION
 * LEDGER_SUB_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.Ledger#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface LedgerSelectable extends EntitySelectable<Ledger>
{

}
