/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerText LedgerText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.field.LedgerTextField LedgerTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.link.LedgerTextLink LedgerTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerText#LEDGER LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerText#LEDGER_NAME LEDGER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ledger.LedgerText#TO_LEDGER TO_LEDGER}</li>
 * </ul>
 *
 */
public interface LedgerTextSelectable extends EntitySelectable<LedgerText>
{

}
