/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.field.LegalCategoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.link.LegalCategoryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.selectable.LegalCategorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Legal Categories
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LegalCategoryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LegalCategory extends VdmEntity<LegalCategory>
{

    /**
     * Selector for all available fields of LegalCategory.
     *
     */
    public final static LegalCategorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategory</b>
     * </p>
     *
     * @return Category ID
     */
    @Key
    @SerializedName( "LglCntntMCategory" )
    @JsonProperty( "LglCntntMCategory" )
    @Nullable
    @ODataField( odataName = "LglCntntMCategory" )
    private String lglCntntMCategory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCategory</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_CATEGORY =
        new LegalCategoryField<String>("LglCntntMCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatType</b>
     * </p>
     *
     * @return Category Type
     */
    @SerializedName( "LglCntntMCatType" )
    @JsonProperty( "LglCntntMCatType" )
    @Nullable
    @ODataField( odataName = "LglCntntMCatType" )
    private String lglCntntMCatType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatType</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_CAT_TYPE =
        new LegalCategoryField<String>("LglCntntMCatType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatIsSelect</b>
     * </p>
     *
     * @return Category Is Selectable
     */
    @SerializedName( "LglCntntMCatIsSelect" )
    @JsonProperty( "LglCntntMCatIsSelect" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LglCntntMCatIsSelect" )
    private Boolean lglCntntMCatIsSelect;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatIsSelect</b> field to query operations.
     *
     */
    public final static LegalCategoryField<Boolean> LGL_CNTNT_M_CAT_IS_SELECT =
        new LegalCategoryField<Boolean>("LglCntntMCatIsSelect");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatIsMultiSelection</b>
     * </p>
     *
     * @return Multiple Selection of Categories
     */
    @SerializedName( "LglCntntMCatIsMultiSelection" )
    @JsonProperty( "LglCntntMCatIsMultiSelection" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LglCntntMCatIsMultiSelection" )
    private Boolean lglCntntMCatIsMultiSelection;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatIsMultiSelection</b> field to query operations.
     *
     */
    public final static LegalCategoryField<Boolean> LGL_CNTNT_M_CAT_IS_MULTI_SELECTION =
        new LegalCategoryField<Boolean>("LglCntntMCatIsMultiSelection");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatLevel</b>
     * </p>
     *
     * @return Category Level
     */
    @SerializedName( "LglCntntMCatLevel" )
    @JsonProperty( "LglCntntMCatLevel" )
    @Nullable
    @ODataField( odataName = "LglCntntMCatLevel" )
    private Short lglCntntMCatLevel;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatLevel</b> field to query operations.
     *
     */
    public final static LegalCategoryField<Short> LGL_CNTNT_M_CAT_LEVEL =
        new LegalCategoryField<Short>("LglCntntMCatLevel");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatIsObsolete</b>
     * </p>
     *
     * @return Category Is Obsolete
     */
    @SerializedName( "LglCntntMCatIsObsolete" )
    @JsonProperty( "LglCntntMCatIsObsolete" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LglCntntMCatIsObsolete" )
    private Boolean lglCntntMCatIsObsolete;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatIsObsolete</b> field to query operations.
     *
     */
    public final static LegalCategoryField<Boolean> LGL_CNTNT_M_CAT_IS_OBSOLETE =
        new LegalCategoryField<Boolean>("LglCntntMCatIsObsolete");
    /**
     * Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatModel</b>
     * </p>
     *
     * @return Model for Dynamic Categories
     */
    @SerializedName( "LglCntntMCatModel" )
    @JsonProperty( "LglCntntMCatModel" )
    @Nullable
    @ODataField( odataName = "LglCntntMCatModel" )
    private String lglCntntMCatModel;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatModel</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_CAT_MODEL =
        new LegalCategoryField<String>("LglCntntMCatModel");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategoryValue</b>
     * </p>
     *
     * @return Category Value
     */
    @SerializedName( "LglCntntMCategoryValue" )
    @JsonProperty( "LglCntntMCategoryValue" )
    @Nullable
    @ODataField( odataName = "LglCntntMCategoryValue" )
    private String lglCntntMCategoryValue;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCategoryValue</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_CATEGORY_VALUE =
        new LegalCategoryField<String>("LglCntntMCategoryValue");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedByUser</b>
     * </p>
     *
     * @return Changed By User
     */
    @SerializedName( "LglCntntMChangedByUser" )
    @JsonProperty( "LglCntntMChangedByUser" )
    @Nullable
    @ODataField( odataName = "LglCntntMChangedByUser" )
    private String lglCntntMChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMChangedByUser</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_CHANGED_BY_USER =
        new LegalCategoryField<String>("LglCntntMChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedUTCDateTime</b>
     * </p>
     *
     * @return Changed UTC Date Time
     */
    @SerializedName( "LglCntntMChangedUTCDateTime" )
    @JsonProperty( "LglCntntMChangedUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LglCntntMChangedUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lglCntntMChangedUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMChangedUTCDateTime</b> field to query operations.
     *
     */
    public final static LegalCategoryField<ZonedDateTime> LGL_CNTNT_M_CHANGED_UTC_DATE_TIME =
        new LegalCategoryField<ZonedDateTime>("LglCntntMChangedUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "LglCntntMCreatedByUser" )
    @JsonProperty( "LglCntntMCreatedByUser" )
    @Nullable
    @ODataField( odataName = "LglCntntMCreatedByUser" )
    private String lglCntntMCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCreatedByUser</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_CREATED_BY_USER =
        new LegalCategoryField<String>("LglCntntMCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedUTCDateTime</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "LglCntntMCreatedUTCDateTime" )
    @JsonProperty( "LglCntntMCreatedUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LglCntntMCreatedUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lglCntntMCreatedUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCreatedUTCDateTime</b> field to query operations.
     *
     */
    public final static LegalCategoryField<ZonedDateTime> LGL_CNTNT_M_CREATED_UTC_DATE_TIME =
        new LegalCategoryField<ZonedDateTime>("LglCntntMCreatedUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMParentCategory</b>
     * </p>
     *
     * @return Parent Category ID
     */
    @SerializedName( "LglCntntMParentCategory" )
    @JsonProperty( "LglCntntMParentCategory" )
    @Nullable
    @ODataField( odataName = "LglCntntMParentCategory" )
    private String lglCntntMParentCategory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMParentCategory</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_PARENT_CATEGORY =
        new LegalCategoryField<String>("LglCntntMParentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRootCategory</b>
     * </p>
     *
     * @return Root Category ID
     */
    @SerializedName( "LglCntntMRootCategory" )
    @JsonProperty( "LglCntntMRootCategory" )
    @Nullable
    @ODataField( odataName = "LglCntntMRootCategory" )
    private String lglCntntMRootCategory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMRootCategory</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_ROOT_CATEGORY =
        new LegalCategoryField<String>("LglCntntMRootCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatPurpose</b>
     * </p>
     *
     * @return Category Purpose
     */
    @SerializedName( "LglCntntMCatPurpose" )
    @JsonProperty( "LglCntntMCatPurpose" )
    @Nullable
    @ODataField( odataName = "LglCntntMCatPurpose" )
    private String lglCntntMCatPurpose;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatPurpose</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_CAT_PURPOSE =
        new LegalCategoryField<String>("LglCntntMCatPurpose");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatIsSystGenerated</b>
     * </p>
     *
     * @return System generated category
     */
    @SerializedName( "LglCntntMCatIsSystGenerated" )
    @JsonProperty( "LglCntntMCatIsSystGenerated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LglCntntMCatIsSystGenerated" )
    private Boolean lglCntntMCatIsSystGenerated;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatIsSystGenerated</b> field to query operations.
     *
     */
    public final static LegalCategoryField<Boolean> LGL_CNTNT_M_CAT_IS_SYST_GENERATED =
        new LegalCategoryField<Boolean>("LglCntntMCatIsSystGenerated");
    /**
     * Constraints: Not nullable, Maximum length: 55
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatConstant</b>
     * </p>
     *
     * @return Category Qualifier
     */
    @SerializedName( "LglCntntMCatConstant" )
    @JsonProperty( "LglCntntMCatConstant" )
    @Nullable
    @ODataField( odataName = "LglCntntMCatConstant" )
    private String lglCntntMCatConstant;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCatConstant</b> field to query operations.
     *
     */
    public final static LegalCategoryField<String> LGL_CNTNT_M_CAT_CONSTANT =
        new LegalCategoryField<String>("LglCntntMCatConstant");
    /**
     * Navigation property <b>to_LegalCategoryText</b> for <b>LegalCategory</b> to multiple <b>LegalCategoryText</b>.
     *
     */
    @SerializedName( "to_LegalCategoryText" )
    @JsonProperty( "to_LegalCategoryText" )
    @ODataField( odataName = "to_LegalCategoryText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LegalCategoryText> toLegalCategoryText;
    /**
     * Use with available fluent helpers to apply the <b>to_LegalCategoryText</b> navigation property to query
     * operations.
     *
     */
    public final static LegalCategoryLink<LegalCategoryText> TO_LEGAL_CATEGORY_TEXT =
        new LegalCategoryLink<LegalCategoryText>("to_LegalCategoryText");

    @Nonnull
    @Override
    public Class<LegalCategory> getType()
    {
        return LegalCategory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategory</b>
     * </p>
     *
     * @param lglCntntMCategory
     *            Category ID
     */
    public void setLglCntntMCategory( @Nullable final String lglCntntMCategory )
    {
        rememberChangedField("LglCntntMCategory", this.lglCntntMCategory);
        this.lglCntntMCategory = lglCntntMCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatType</b>
     * </p>
     *
     * @param lglCntntMCatType
     *            Category Type
     */
    public void setLglCntntMCatType( @Nullable final String lglCntntMCatType )
    {
        rememberChangedField("LglCntntMCatType", this.lglCntntMCatType);
        this.lglCntntMCatType = lglCntntMCatType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatIsSelect</b>
     * </p>
     *
     * @param lglCntntMCatIsSelect
     *            Category Is Selectable
     */
    public void setLglCntntMCatIsSelect( @Nullable final Boolean lglCntntMCatIsSelect )
    {
        rememberChangedField("LglCntntMCatIsSelect", this.lglCntntMCatIsSelect);
        this.lglCntntMCatIsSelect = lglCntntMCatIsSelect;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatIsMultiSelection</b>
     * </p>
     *
     * @param lglCntntMCatIsMultiSelection
     *            Multiple Selection of Categories
     */
    public void setLglCntntMCatIsMultiSelection( @Nullable final Boolean lglCntntMCatIsMultiSelection )
    {
        rememberChangedField("LglCntntMCatIsMultiSelection", this.lglCntntMCatIsMultiSelection);
        this.lglCntntMCatIsMultiSelection = lglCntntMCatIsMultiSelection;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatLevel</b>
     * </p>
     *
     * @param lglCntntMCatLevel
     *            Category Level
     */
    public void setLglCntntMCatLevel( @Nullable final Short lglCntntMCatLevel )
    {
        rememberChangedField("LglCntntMCatLevel", this.lglCntntMCatLevel);
        this.lglCntntMCatLevel = lglCntntMCatLevel;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatIsObsolete</b>
     * </p>
     *
     * @param lglCntntMCatIsObsolete
     *            Category Is Obsolete
     */
    public void setLglCntntMCatIsObsolete( @Nullable final Boolean lglCntntMCatIsObsolete )
    {
        rememberChangedField("LglCntntMCatIsObsolete", this.lglCntntMCatIsObsolete);
        this.lglCntntMCatIsObsolete = lglCntntMCatIsObsolete;
    }

    /**
     * Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatModel</b>
     * </p>
     *
     * @param lglCntntMCatModel
     *            Model for Dynamic Categories
     */
    public void setLglCntntMCatModel( @Nullable final String lglCntntMCatModel )
    {
        rememberChangedField("LglCntntMCatModel", this.lglCntntMCatModel);
        this.lglCntntMCatModel = lglCntntMCatModel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategoryValue</b>
     * </p>
     *
     * @param lglCntntMCategoryValue
     *            Category Value
     */
    public void setLglCntntMCategoryValue( @Nullable final String lglCntntMCategoryValue )
    {
        rememberChangedField("LglCntntMCategoryValue", this.lglCntntMCategoryValue);
        this.lglCntntMCategoryValue = lglCntntMCategoryValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedByUser</b>
     * </p>
     *
     * @param lglCntntMChangedByUser
     *            Changed By User
     */
    public void setLglCntntMChangedByUser( @Nullable final String lglCntntMChangedByUser )
    {
        rememberChangedField("LglCntntMChangedByUser", this.lglCntntMChangedByUser);
        this.lglCntntMChangedByUser = lglCntntMChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedUTCDateTime</b>
     * </p>
     *
     * @param lglCntntMChangedUTCDateTime
     *            Changed UTC Date Time
     */
    public void setLglCntntMChangedUTCDateTime( @Nullable final ZonedDateTime lglCntntMChangedUTCDateTime )
    {
        rememberChangedField("LglCntntMChangedUTCDateTime", this.lglCntntMChangedUTCDateTime);
        this.lglCntntMChangedUTCDateTime = lglCntntMChangedUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedByUser</b>
     * </p>
     *
     * @param lglCntntMCreatedByUser
     *            Created By
     */
    public void setLglCntntMCreatedByUser( @Nullable final String lglCntntMCreatedByUser )
    {
        rememberChangedField("LglCntntMCreatedByUser", this.lglCntntMCreatedByUser);
        this.lglCntntMCreatedByUser = lglCntntMCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedUTCDateTime</b>
     * </p>
     *
     * @param lglCntntMCreatedUTCDateTime
     *            Created On
     */
    public void setLglCntntMCreatedUTCDateTime( @Nullable final ZonedDateTime lglCntntMCreatedUTCDateTime )
    {
        rememberChangedField("LglCntntMCreatedUTCDateTime", this.lglCntntMCreatedUTCDateTime);
        this.lglCntntMCreatedUTCDateTime = lglCntntMCreatedUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMParentCategory</b>
     * </p>
     *
     * @param lglCntntMParentCategory
     *            Parent Category ID
     */
    public void setLglCntntMParentCategory( @Nullable final String lglCntntMParentCategory )
    {
        rememberChangedField("LglCntntMParentCategory", this.lglCntntMParentCategory);
        this.lglCntntMParentCategory = lglCntntMParentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMRootCategory</b>
     * </p>
     *
     * @param lglCntntMRootCategory
     *            Root Category ID
     */
    public void setLglCntntMRootCategory( @Nullable final String lglCntntMRootCategory )
    {
        rememberChangedField("LglCntntMRootCategory", this.lglCntntMRootCategory);
        this.lglCntntMRootCategory = lglCntntMRootCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatPurpose</b>
     * </p>
     *
     * @param lglCntntMCatPurpose
     *            Category Purpose
     */
    public void setLglCntntMCatPurpose( @Nullable final String lglCntntMCatPurpose )
    {
        rememberChangedField("LglCntntMCatPurpose", this.lglCntntMCatPurpose);
        this.lglCntntMCatPurpose = lglCntntMCatPurpose;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatIsSystGenerated</b>
     * </p>
     *
     * @param lglCntntMCatIsSystGenerated
     *            System generated category
     */
    public void setLglCntntMCatIsSystGenerated( @Nullable final Boolean lglCntntMCatIsSystGenerated )
    {
        rememberChangedField("LglCntntMCatIsSystGenerated", this.lglCntntMCatIsSystGenerated);
        this.lglCntntMCatIsSystGenerated = lglCntntMCatIsSystGenerated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 55
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCatConstant</b>
     * </p>
     *
     * @param lglCntntMCatConstant
     *            Category Qualifier
     */
    public void setLglCntntMCatConstant( @Nullable final String lglCntntMCatConstant )
    {
        rememberChangedField("LglCntntMCatConstant", this.lglCntntMCatConstant);
        this.lglCntntMCatConstant = lglCntntMCatConstant;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LegalCategory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMCategory", getLglCntntMCategory());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMCategory", getLglCntntMCategory());
        values.put("LglCntntMCatType", getLglCntntMCatType());
        values.put("LglCntntMCatIsSelect", getLglCntntMCatIsSelect());
        values.put("LglCntntMCatIsMultiSelection", getLglCntntMCatIsMultiSelection());
        values.put("LglCntntMCatLevel", getLglCntntMCatLevel());
        values.put("LglCntntMCatIsObsolete", getLglCntntMCatIsObsolete());
        values.put("LglCntntMCatModel", getLglCntntMCatModel());
        values.put("LglCntntMCategoryValue", getLglCntntMCategoryValue());
        values.put("LglCntntMChangedByUser", getLglCntntMChangedByUser());
        values.put("LglCntntMChangedUTCDateTime", getLglCntntMChangedUTCDateTime());
        values.put("LglCntntMCreatedByUser", getLglCntntMCreatedByUser());
        values.put("LglCntntMCreatedUTCDateTime", getLglCntntMCreatedUTCDateTime());
        values.put("LglCntntMParentCategory", getLglCntntMParentCategory());
        values.put("LglCntntMRootCategory", getLglCntntMRootCategory());
        values.put("LglCntntMCatPurpose", getLglCntntMCatPurpose());
        values.put("LglCntntMCatIsSystGenerated", getLglCntntMCatIsSystGenerated());
        values.put("LglCntntMCatConstant", getLglCntntMCatConstant());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMCategory") ) {
                final Object value = values.remove("LglCntntMCategory");
                if( (value == null) || (!value.equals(getLglCntntMCategory())) ) {
                    setLglCntntMCategory(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCatType") ) {
                final Object value = values.remove("LglCntntMCatType");
                if( (value == null) || (!value.equals(getLglCntntMCatType())) ) {
                    setLglCntntMCatType(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCatIsSelect") ) {
                final Object value = values.remove("LglCntntMCatIsSelect");
                if( (value == null) || (!value.equals(getLglCntntMCatIsSelect())) ) {
                    setLglCntntMCatIsSelect(((Boolean) value));
                }
            }
            if( values.containsKey("LglCntntMCatIsMultiSelection") ) {
                final Object value = values.remove("LglCntntMCatIsMultiSelection");
                if( (value == null) || (!value.equals(getLglCntntMCatIsMultiSelection())) ) {
                    setLglCntntMCatIsMultiSelection(((Boolean) value));
                }
            }
            if( values.containsKey("LglCntntMCatLevel") ) {
                final Object value = values.remove("LglCntntMCatLevel");
                if( (value == null) || (!value.equals(getLglCntntMCatLevel())) ) {
                    setLglCntntMCatLevel(((Short) value));
                }
            }
            if( values.containsKey("LglCntntMCatIsObsolete") ) {
                final Object value = values.remove("LglCntntMCatIsObsolete");
                if( (value == null) || (!value.equals(getLglCntntMCatIsObsolete())) ) {
                    setLglCntntMCatIsObsolete(((Boolean) value));
                }
            }
            if( values.containsKey("LglCntntMCatModel") ) {
                final Object value = values.remove("LglCntntMCatModel");
                if( (value == null) || (!value.equals(getLglCntntMCatModel())) ) {
                    setLglCntntMCatModel(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCategoryValue") ) {
                final Object value = values.remove("LglCntntMCategoryValue");
                if( (value == null) || (!value.equals(getLglCntntMCategoryValue())) ) {
                    setLglCntntMCategoryValue(((String) value));
                }
            }
            if( values.containsKey("LglCntntMChangedByUser") ) {
                final Object value = values.remove("LglCntntMChangedByUser");
                if( (value == null) || (!value.equals(getLglCntntMChangedByUser())) ) {
                    setLglCntntMChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LglCntntMChangedUTCDateTime") ) {
                final Object value = values.remove("LglCntntMChangedUTCDateTime");
                if( (value == null) || (!value.equals(getLglCntntMChangedUTCDateTime())) ) {
                    setLglCntntMChangedUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LglCntntMCreatedByUser") ) {
                final Object value = values.remove("LglCntntMCreatedByUser");
                if( (value == null) || (!value.equals(getLglCntntMCreatedByUser())) ) {
                    setLglCntntMCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCreatedUTCDateTime") ) {
                final Object value = values.remove("LglCntntMCreatedUTCDateTime");
                if( (value == null) || (!value.equals(getLglCntntMCreatedUTCDateTime())) ) {
                    setLglCntntMCreatedUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LglCntntMParentCategory") ) {
                final Object value = values.remove("LglCntntMParentCategory");
                if( (value == null) || (!value.equals(getLglCntntMParentCategory())) ) {
                    setLglCntntMParentCategory(((String) value));
                }
            }
            if( values.containsKey("LglCntntMRootCategory") ) {
                final Object value = values.remove("LglCntntMRootCategory");
                if( (value == null) || (!value.equals(getLglCntntMRootCategory())) ) {
                    setLglCntntMRootCategory(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCatPurpose") ) {
                final Object value = values.remove("LglCntntMCatPurpose");
                if( (value == null) || (!value.equals(getLglCntntMCatPurpose())) ) {
                    setLglCntntMCatPurpose(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCatIsSystGenerated") ) {
                final Object value = values.remove("LglCntntMCatIsSystGenerated");
                if( (value == null) || (!value.equals(getLglCntntMCatIsSystGenerated())) ) {
                    setLglCntntMCatIsSystGenerated(((Boolean) value));
                }
            }
            if( values.containsKey("LglCntntMCatConstant") ) {
                final Object value = values.remove("LglCntntMCatConstant");
                if( (value == null) || (!value.equals(getLglCntntMCatConstant())) ) {
                    setLglCntntMCatConstant(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LegalCategoryText") ) {
                final Object value = (values).remove("to_LegalCategoryText");
                if( value instanceof Iterable ) {
                    if( toLegalCategoryText == null ) {
                        toLegalCategoryText = Lists.newArrayList();
                    } else {
                        toLegalCategoryText = Lists.newArrayList(toLegalCategoryText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LegalCategoryText entity;
                        if( toLegalCategoryText.size() > i ) {
                            entity = toLegalCategoryText.get(i);
                        } else {
                            entity = new LegalCategoryText();
                            toLegalCategoryText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LegalCategoryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LegalCategoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LegalCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LegalCategoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLegalCategoryText != null ) {
            (values).put("to_LegalCategoryText", toLegalCategoryText);
        }
        return values;
    }

    /**
     * Fetches the <b>LegalCategoryText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_LegalCategoryText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LegalCategoryText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LegalCategoryText> fetchLegalCategoryText()
    {
        return fetchFieldAsList("to_LegalCategoryText", LegalCategoryText.class);
    }

    /**
     * Retrieval of associated <b>LegalCategoryText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LegalCategoryText</b>.
     * <p>
     * If the navigation property <b>to_LegalCategoryText</b> of a queried <b>LegalCategory</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LegalCategoryText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LegalCategoryText> getLegalCategoryTextOrFetch()
    {
        if( toLegalCategoryText == null ) {
            toLegalCategoryText = fetchLegalCategoryText();
        }
        return toLegalCategoryText;
    }

    /**
     * Retrieval of associated <b>LegalCategoryText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LegalCategoryText</b>.
     * <p>
     * If the navigation property for an entity <b>LegalCategory</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LegalCategoryText</b> is already loaded, the result will
     *         contain the <b>LegalCategoryText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LegalCategoryText>> getLegalCategoryTextIfPresent()
    {
        return Option.of(toLegalCategoryText);
    }

    /**
     * Overwrites the list of associated <b>LegalCategoryText</b> entities for the loaded navigation property
     * <b>to_LegalCategoryText</b>.
     * <p>
     * If the navigation property <b>to_LegalCategoryText</b> of a queried <b>LegalCategory</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LegalCategoryText</b> entities.
     */
    public void setLegalCategoryText( @Nonnull final List<LegalCategoryText> value )
    {
        if( toLegalCategoryText == null ) {
            toLegalCategoryText = Lists.newArrayList();
        }
        toLegalCategoryText.clear();
        toLegalCategoryText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LegalCategoryText</b> entities. This corresponds to the OData
     * navigation property <b>to_LegalCategoryText</b>.
     * <p>
     * If the navigation property <b>to_LegalCategoryText</b> of a queried <b>LegalCategory</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LegalCategoryText</b> entities.
     */
    public void addLegalCategoryText( LegalCategoryText... entity )
    {
        if( toLegalCategoryText == null ) {
            toLegalCategoryText = Lists.newArrayList();
        }
        toLegalCategoryText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LegalCategory instances.
     *
     */
    public final static class LegalCategoryBuilder
    {

        private List<LegalCategoryText> toLegalCategoryText = Lists.newArrayList();

        private LegalCategory.LegalCategoryBuilder toLegalCategoryText( final List<LegalCategoryText> value )
        {
            toLegalCategoryText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LegalCategoryText</b> for <b>LegalCategory</b> to multiple
         * <b>LegalCategoryText</b>.
         *
         * @param value
         *            The LegalCategoryTexts to build this LegalCategory with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalCategory.LegalCategoryBuilder legalCategoryText( LegalCategoryText... value )
        {
            return toLegalCategoryText(Lists.newArrayList(value));
        }

    }

}
