/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.field.LegalCategoryTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.selectable.LegalCategoryTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Legal Category - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LegalCategoryTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LegalCategoryText extends VdmEntity<LegalCategoryText>
{

    /**
     * Selector for all available fields of LegalCategoryText.
     *
     */
    public final static LegalCategoryTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategory</b>
     * </p>
     *
     * @return Category ID
     */
    @Key
    @SerializedName( "LglCntntMCategory" )
    @JsonProperty( "LglCntntMCategory" )
    @Nullable
    @ODataField( odataName = "LglCntntMCategory" )
    private String lglCntntMCategory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCategory</b> field to query operations.
     *
     */
    public final static LegalCategoryTextField<String> LGL_CNTNT_M_CATEGORY =
        new LegalCategoryTextField<String>("LglCntntMCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static LegalCategoryTextField<String> LANGUAGE = new LegalCategoryTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategoryName</b>
     * </p>
     *
     * @return Category Name
     */
    @SerializedName( "LglCntntMCategoryName" )
    @JsonProperty( "LglCntntMCategoryName" )
    @Nullable
    @ODataField( odataName = "LglCntntMCategoryName" )
    private String lglCntntMCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCategoryName</b> field to query operations.
     *
     */
    public final static LegalCategoryTextField<String> LGL_CNTNT_M_CATEGORY_NAME =
        new LegalCategoryTextField<String>("LglCntntMCategoryName");

    @Nonnull
    @Override
    public Class<LegalCategoryText> getType()
    {
        return LegalCategoryText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategory</b>
     * </p>
     *
     * @param lglCntntMCategory
     *            Category ID
     */
    public void setLglCntntMCategory( @Nullable final String lglCntntMCategory )
    {
        rememberChangedField("LglCntntMCategory", this.lglCntntMCategory);
        this.lglCntntMCategory = lglCntntMCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategoryName</b>
     * </p>
     *
     * @param lglCntntMCategoryName
     *            Category Name
     */
    public void setLglCntntMCategoryName( @Nullable final String lglCntntMCategoryName )
    {
        rememberChangedField("LglCntntMCategoryName", this.lglCntntMCategoryName);
        this.lglCntntMCategoryName = lglCntntMCategoryName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LegalCategoryText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMCategory", getLglCntntMCategory());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMCategory", getLglCntntMCategory());
        values.put("Language", getLanguage());
        values.put("LglCntntMCategoryName", getLglCntntMCategoryName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMCategory") ) {
                final Object value = values.remove("LglCntntMCategory");
                if( (value == null) || (!value.equals(getLglCntntMCategory())) ) {
                    setLglCntntMCategory(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCategoryName") ) {
                final Object value = values.remove("LglCntntMCategoryName");
                if( (value == null) || (!value.equals(getLglCntntMCategoryName())) ) {
                    setLglCntntMCategoryName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LegalCategoryTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LegalCategoryTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LegalCategoryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LegalCategoryTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService.DEFAULT_SERVICE_PATH);
    }

}
