/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link LegalCategorieServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService LegalCategorieService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultLegalCategorieServiceBatch
    extends
    BatchFluentHelperBasic<LegalCategorieServiceBatch, LegalCategorieServiceBatchChangeSet>
    implements
    LegalCategorieServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultLegalCategorieServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalCategorieServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultLegalCategorieServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalCategorieServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultLegalCategorieServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LegalCategorieServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultLegalCategorieServiceBatchChangeSet(this, service);
    }

}
