/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link LegalCategorieServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService LegalCategorieService}.
 *
 */
public class DefaultLegalCategorieServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<LegalCategorieServiceBatch, LegalCategorieServiceBatchChangeSet>
    implements
    LegalCategorieServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService service;

    @SuppressWarnings( "deprecation" )
    DefaultLegalCategorieServiceBatchChangeSet(
        @Nonnull final DefaultLegalCategorieServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalCategorieService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultLegalCategorieServiceBatchChangeSet getThis()
    {
        return this;
    }

}
