/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory LegalCategory}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.field.LegalCategoryField
 * LegalCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.link.LegalCategoryLink LegalCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CATEGORY
 * LGL_CNTNT_M_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CAT_TYPE
 * LGL_CNTNT_M_CAT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CAT_IS_SELECT
 * LGL_CNTNT_M_CAT_IS_SELECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CAT_IS_MULTI_SELECTION
 * LGL_CNTNT_M_CAT_IS_MULTI_SELECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CAT_LEVEL
 * LGL_CNTNT_M_CAT_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CAT_IS_OBSOLETE
 * LGL_CNTNT_M_CAT_IS_OBSOLETE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CAT_MODEL
 * LGL_CNTNT_M_CAT_MODEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CATEGORY_VALUE
 * LGL_CNTNT_M_CATEGORY_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CHANGED_BY_USER
 * LGL_CNTNT_M_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CHANGED_UTC_DATE_TIME
 * LGL_CNTNT_M_CHANGED_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CREATED_BY_USER
 * LGL_CNTNT_M_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CREATED_UTC_DATE_TIME
 * LGL_CNTNT_M_CREATED_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_PARENT_CATEGORY
 * LGL_CNTNT_M_PARENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_ROOT_CATEGORY
 * LGL_CNTNT_M_ROOT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CAT_PURPOSE
 * LGL_CNTNT_M_CAT_PURPOSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CAT_IS_SYST_GENERATED
 * LGL_CNTNT_M_CAT_IS_SYST_GENERATED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#LGL_CNTNT_M_CAT_CONSTANT
 * LGL_CNTNT_M_CAT_CONSTANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategory#TO_LEGAL_CATEGORY_TEXT
 * TO_LEGAL_CATEGORY_TEXT}</li>
 * </ul>
 *
 */
public interface LegalCategorySelectable extends EntitySelectable<LegalCategory>
{

}
