/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategoryText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategoryText LegalCategoryText}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.field.LegalCategoryTextField
 * LegalCategoryTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.link.LegalCategoryTextLink
 * LegalCategoryTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategoryText#LGL_CNTNT_M_CATEGORY
 * LGL_CNTNT_M_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategoryText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legalcategorie.LegalCategoryText#LGL_CNTNT_M_CATEGORY_NAME
 * LGL_CNTNT_M_CATEGORY_NAME}</li>
 * </ul>
 *
 */
public interface LegalCategoryTextSelectable extends EntitySelectable<LegalCategoryText>
{

}
