/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.field.LegalDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.link.LegalDocumentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.selectable.LegalDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Legal Document
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LegalDocumentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LegalDocument extends VdmEntity<LegalDocument>
{

    /**
     * Selector for all available fields of LegalDocument.
     *
     */
    public final static LegalDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LglCntntMDocumentUUID" )
    @JsonProperty( "LglCntntMDocumentUUID" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocumentUUID" )
    private UUID lglCntntMDocumentUUID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocumentUUID</b> field to query operations.
     *
     */
    public final static LegalDocumentField<UUID> LGL_CNTNT_M_DOCUMENT_UUID =
        new LegalDocumentField<UUID>("LglCntntMDocumentUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocument</b>
     * </p>
     *
     * @return Document ID
     */
    @SerializedName( "LglCntntMDocument" )
    @JsonProperty( "LglCntntMDocument" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocument" )
    private String lglCntntMDocument;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocument</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_DOCUMENT =
        new LegalDocumentField<String>("LglCntntMDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentLinkedObject</b>
     * </p>
     *
     * @return Linked SAP Object
     */
    @SerializedName( "LglCntntMDocumentLinkedObject" )
    @JsonProperty( "LglCntntMDocumentLinkedObject" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocumentLinkedObject" )
    private String lglCntntMDocumentLinkedObject;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocumentLinkedObject</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_DOCUMENT_LINKED_OBJECT =
        new LegalDocumentField<String>("LglCntntMDocumentLinkedObject");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentLinkedObjKey</b>
     * </p>
     *
     * @return UUID Char32
     */
    @SerializedName( "LglCntntMDocumentLinkedObjKey" )
    @JsonProperty( "LglCntntMDocumentLinkedObjKey" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocumentLinkedObjKey" )
    private UUID lglCntntMDocumentLinkedObjKey;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocumentLinkedObjKey</b> field to query operations.
     *
     */
    public final static LegalDocumentField<UUID> LGL_CNTNT_M_DOCUMENT_LINKED_OBJ_KEY =
        new LegalDocumentField<UUID>("LglCntntMDocumentLinkedObjKey");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransaction</b>
     * </p>
     *
     * @return Legal Transaction ID
     */
    @SerializedName( "LegalTransaction" )
    @JsonProperty( "LegalTransaction" )
    @Nullable
    @ODataField( odataName = "LegalTransaction" )
    private String legalTransaction;
    /**
     * Use with available fluent helpers to apply the <b>LegalTransaction</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LEGAL_TRANSACTION =
        new LegalDocumentField<String>("LegalTransaction");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocContentType</b>
     * </p>
     *
     * @return Document Content Type
     */
    @SerializedName( "LglCntntMDocContentType" )
    @JsonProperty( "LglCntntMDocContentType" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocContentType" )
    private String lglCntntMDocContentType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocContentType</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_DOC_CONTENT_TYPE =
        new LegalDocumentField<String>("LglCntntMDocContentType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMLanguage</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "LglCntntMLanguage" )
    @JsonProperty( "LglCntntMLanguage" )
    @Nullable
    @ODataField( odataName = "LglCntntMLanguage" )
    private String lglCntntMLanguage;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMLanguage</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_LANGUAGE =
        new LegalDocumentField<String>("LglCntntMLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDescription</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "DocumentDescription" )
    @JsonProperty( "DocumentDescription" )
    @Nullable
    @ODataField( odataName = "DocumentDescription" )
    private String documentDescription;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDescription</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> DOCUMENT_DESCRIPTION =
        new LegalDocumentField<String>("DocumentDescription");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocAccessLvl</b>
     * </p>
     *
     * @return Access Level
     */
    @SerializedName( "LglCntntMDocAccessLvl" )
    @JsonProperty( "LglCntntMDocAccessLvl" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocAccessLvl" )
    private String lglCntntMDocAccessLvl;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocAccessLvl</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_DOC_ACCESS_LVL =
        new LegalDocumentField<String>("LglCntntMDocAccessLvl");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LegalDocumentSource</b>
     * </p>
     *
     * @return Document Source
     */
    @SerializedName( "LegalDocumentSource" )
    @JsonProperty( "LegalDocumentSource" )
    @Nullable
    @ODataField( odataName = "LegalDocumentSource" )
    private String legalDocumentSource;
    /**
     * Use with available fluent helpers to apply the <b>LegalDocumentSource</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LEGAL_DOCUMENT_SOURCE =
        new LegalDocumentField<String>("LegalDocumentSource");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedUTCDateTime</b>
     * </p>
     *
     * @return Changed UTC Date Time
     */
    @SerializedName( "LglCntntMChangedUTCDateTime" )
    @JsonProperty( "LglCntntMChangedUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LglCntntMChangedUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lglCntntMChangedUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMChangedUTCDateTime</b> field to query operations.
     *
     */
    public final static LegalDocumentField<ZonedDateTime> LGL_CNTNT_M_CHANGED_UTC_DATE_TIME =
        new LegalDocumentField<ZonedDateTime>("LglCntntMChangedUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedByUser</b>
     * </p>
     *
     * @return Changed By User
     */
    @SerializedName( "LglCntntMChangedByUser" )
    @JsonProperty( "LglCntntMChangedByUser" )
    @Nullable
    @ODataField( odataName = "LglCntntMChangedByUser" )
    private String lglCntntMChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMChangedByUser</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_CHANGED_BY_USER =
        new LegalDocumentField<String>("LglCntntMChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedUTCDateTime</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "LglCntntMCreatedUTCDateTime" )
    @JsonProperty( "LglCntntMCreatedUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LglCntntMCreatedUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lglCntntMCreatedUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCreatedUTCDateTime</b> field to query operations.
     *
     */
    public final static LegalDocumentField<ZonedDateTime> LGL_CNTNT_M_CREATED_UTC_DATE_TIME =
        new LegalDocumentField<ZonedDateTime>("LglCntntMCreatedUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "LglCntntMCreatedByUser" )
    @JsonProperty( "LglCntntMCreatedByUser" )
    @Nullable
    @ODataField( odataName = "LglCntntMCreatedByUser" )
    private String lglCntntMCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCreatedByUser</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_CREATED_BY_USER =
        new LegalDocumentField<String>("LglCntntMCreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @return Document Status
     */
    @SerializedName( "InternalDocumentStatus" )
    @JsonProperty( "InternalDocumentStatus" )
    @Nullable
    @ODataField( odataName = "InternalDocumentStatus" )
    private String internalDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>InternalDocumentStatus</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> INTERNAL_DOCUMENT_STATUS =
        new LegalDocumentField<String>("InternalDocumentStatus");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentIsTopVersion</b>
     * </p>
     *
     * @return Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    @SerializedName( "LglCntntMDocumentIsTopVersion" )
    @JsonProperty( "LglCntntMDocumentIsTopVersion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "LglCntntMDocumentIsTopVersion" )
    private Boolean lglCntntMDocumentIsTopVersion;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocumentIsTopVersion</b> field to query operations.
     *
     */
    public final static LegalDocumentField<Boolean> LGL_CNTNT_M_DOCUMENT_IS_TOP_VERSION =
        new LegalDocumentField<Boolean>("LglCntntMDocumentIsTopVersion");
    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMVirtualDocVersKey</b>
     * </p>
     *
     * @return Virtual Document Version Key
     */
    @SerializedName( "LglCntntMVirtualDocVersKey" )
    @JsonProperty( "LglCntntMVirtualDocVersKey" )
    @Nullable
    @ODataField( odataName = "LglCntntMVirtualDocVersKey" )
    private String lglCntntMVirtualDocVersKey;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMVirtualDocVersKey</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_VIRTUAL_DOC_VERS_KEY =
        new LegalDocumentField<String>("LglCntntMVirtualDocVersKey");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocAssemblyStatus</b>
     * </p>
     *
     * @return Document Assembly Status
     */
    @SerializedName( "LglCntntMDocAssemblyStatus" )
    @JsonProperty( "LglCntntMDocAssemblyStatus" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocAssemblyStatus" )
    private String lglCntntMDocAssemblyStatus;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocAssemblyStatus</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_DOC_ASSEMBLY_STATUS =
        new LegalDocumentField<String>("LglCntntMDocAssemblyStatus");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMTmplID</b>
     * </p>
     *
     * @return Template ID
     */
    @SerializedName( "LglCntntMTmplID" )
    @JsonProperty( "LglCntntMTmplID" )
    @Nullable
    @ODataField( odataName = "LglCntntMTmplID" )
    private String lglCntntMTmplID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMTmplID</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_TMPL_ID =
        new LegalDocumentField<String>("LglCntntMTmplID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocType</b>
     * </p>
     *
     * @return Document Type
     */
    @SerializedName( "LglCntntMDocType" )
    @JsonProperty( "LglCntntMDocType" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocType" )
    private String lglCntntMDocType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocType</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_DOC_TYPE =
        new LegalDocumentField<String>("LglCntntMDocType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocLowTouchLevel</b>
     * </p>
     *
     * @return Indicates the Assembly Automation Level of a Document
     */
    @SerializedName( "LglCntntMDocLowTouchLevel" )
    @JsonProperty( "LglCntntMDocLowTouchLevel" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocLowTouchLevel" )
    private String lglCntntMDocLowTouchLevel;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocLowTouchLevel</b> field to query operations.
     *
     */
    public final static LegalDocumentField<String> LGL_CNTNT_M_DOC_LOW_TOUCH_LEVEL =
        new LegalDocumentField<String>("LglCntntMDocLowTouchLevel");
    /**
     * Navigation property <b>to_LglCntntMDocParCategory</b> for <b>LegalDocument</b> to multiple
     * <b>LglCntntMDocParCategory</b>.
     *
     */
    @SerializedName( "to_LglCntntMDocParCategory" )
    @JsonProperty( "to_LglCntntMDocParCategory" )
    @ODataField( odataName = "to_LglCntntMDocParCategory" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglCntntMDocParCategory> toLglCntntMDocParCategory;
    /**
     * Navigation property <b>to_LglDocStamp</b> for <b>LegalDocument</b> to multiple <b>LglDocStamp</b>.
     *
     */
    @SerializedName( "to_LglDocStamp" )
    @JsonProperty( "to_LglDocStamp" )
    @ODataField( odataName = "to_LglDocStamp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglDocStamp> toLglDocStamp;
    /**
     * Use with available fluent helpers to apply the <b>to_LglCntntMDocParCategory</b> navigation property to query
     * operations.
     *
     */
    public final static LegalDocumentLink<LglCntntMDocParCategory> TO_LGL_CNTNT_M_DOC_PAR_CATEGORY =
        new LegalDocumentLink<LglCntntMDocParCategory>("to_LglCntntMDocParCategory");
    /**
     * Use with available fluent helpers to apply the <b>to_LglDocStamp</b> navigation property to query operations.
     *
     */
    public final static LegalDocumentLink<LglDocStamp> TO_LGL_DOC_STAMP =
        new LegalDocumentLink<LglDocStamp>("to_LglDocStamp");

    @Nonnull
    @Override
    public Class<LegalDocument> getType()
    {
        return LegalDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentUUID</b>
     * </p>
     *
     * @param lglCntntMDocumentUUID
     *            Universal Unique Identifier
     */
    public void setLglCntntMDocumentUUID( @Nullable final UUID lglCntntMDocumentUUID )
    {
        rememberChangedField("LglCntntMDocumentUUID", this.lglCntntMDocumentUUID);
        this.lglCntntMDocumentUUID = lglCntntMDocumentUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocument</b>
     * </p>
     *
     * @param lglCntntMDocument
     *            Document ID
     */
    public void setLglCntntMDocument( @Nullable final String lglCntntMDocument )
    {
        rememberChangedField("LglCntntMDocument", this.lglCntntMDocument);
        this.lglCntntMDocument = lglCntntMDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentLinkedObject</b>
     * </p>
     *
     * @param lglCntntMDocumentLinkedObject
     *            Linked SAP Object
     */
    public void setLglCntntMDocumentLinkedObject( @Nullable final String lglCntntMDocumentLinkedObject )
    {
        rememberChangedField("LglCntntMDocumentLinkedObject", this.lglCntntMDocumentLinkedObject);
        this.lglCntntMDocumentLinkedObject = lglCntntMDocumentLinkedObject;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentLinkedObjKey</b>
     * </p>
     *
     * @param lglCntntMDocumentLinkedObjKey
     *            UUID Char32
     */
    public void setLglCntntMDocumentLinkedObjKey( @Nullable final UUID lglCntntMDocumentLinkedObjKey )
    {
        rememberChangedField("LglCntntMDocumentLinkedObjKey", this.lglCntntMDocumentLinkedObjKey);
        this.lglCntntMDocumentLinkedObjKey = lglCntntMDocumentLinkedObjKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LegalTransaction</b>
     * </p>
     *
     * @param legalTransaction
     *            Legal Transaction ID
     */
    public void setLegalTransaction( @Nullable final String legalTransaction )
    {
        rememberChangedField("LegalTransaction", this.legalTransaction);
        this.legalTransaction = legalTransaction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocContentType</b>
     * </p>
     *
     * @param lglCntntMDocContentType
     *            Document Content Type
     */
    public void setLglCntntMDocContentType( @Nullable final String lglCntntMDocContentType )
    {
        rememberChangedField("LglCntntMDocContentType", this.lglCntntMDocContentType);
        this.lglCntntMDocContentType = lglCntntMDocContentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMLanguage</b>
     * </p>
     *
     * @param lglCntntMLanguage
     *            Language Key
     */
    public void setLglCntntMLanguage( @Nullable final String lglCntntMLanguage )
    {
        rememberChangedField("LglCntntMLanguage", this.lglCntntMLanguage);
        this.lglCntntMLanguage = lglCntntMLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDescription</b>
     * </p>
     *
     * @param documentDescription
     *            Name
     */
    public void setDocumentDescription( @Nullable final String documentDescription )
    {
        rememberChangedField("DocumentDescription", this.documentDescription);
        this.documentDescription = documentDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocAccessLvl</b>
     * </p>
     *
     * @param lglCntntMDocAccessLvl
     *            Access Level
     */
    public void setLglCntntMDocAccessLvl( @Nullable final String lglCntntMDocAccessLvl )
    {
        rememberChangedField("LglCntntMDocAccessLvl", this.lglCntntMDocAccessLvl);
        this.lglCntntMDocAccessLvl = lglCntntMDocAccessLvl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LegalDocumentSource</b>
     * </p>
     *
     * @param legalDocumentSource
     *            Document Source
     */
    public void setLegalDocumentSource( @Nullable final String legalDocumentSource )
    {
        rememberChangedField("LegalDocumentSource", this.legalDocumentSource);
        this.legalDocumentSource = legalDocumentSource;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedUTCDateTime</b>
     * </p>
     *
     * @param lglCntntMChangedUTCDateTime
     *            Changed UTC Date Time
     */
    public void setLglCntntMChangedUTCDateTime( @Nullable final ZonedDateTime lglCntntMChangedUTCDateTime )
    {
        rememberChangedField("LglCntntMChangedUTCDateTime", this.lglCntntMChangedUTCDateTime);
        this.lglCntntMChangedUTCDateTime = lglCntntMChangedUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMChangedByUser</b>
     * </p>
     *
     * @param lglCntntMChangedByUser
     *            Changed By User
     */
    public void setLglCntntMChangedByUser( @Nullable final String lglCntntMChangedByUser )
    {
        rememberChangedField("LglCntntMChangedByUser", this.lglCntntMChangedByUser);
        this.lglCntntMChangedByUser = lglCntntMChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedUTCDateTime</b>
     * </p>
     *
     * @param lglCntntMCreatedUTCDateTime
     *            Created On
     */
    public void setLglCntntMCreatedUTCDateTime( @Nullable final ZonedDateTime lglCntntMCreatedUTCDateTime )
    {
        rememberChangedField("LglCntntMCreatedUTCDateTime", this.lglCntntMCreatedUTCDateTime);
        this.lglCntntMCreatedUTCDateTime = lglCntntMCreatedUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedByUser</b>
     * </p>
     *
     * @param lglCntntMCreatedByUser
     *            Created By
     */
    public void setLglCntntMCreatedByUser( @Nullable final String lglCntntMCreatedByUser )
    {
        rememberChangedField("LglCntntMCreatedByUser", this.lglCntntMCreatedByUser);
        this.lglCntntMCreatedByUser = lglCntntMCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @param internalDocumentStatus
     *            Document Status
     */
    public void setInternalDocumentStatus( @Nullable final String internalDocumentStatus )
    {
        rememberChangedField("InternalDocumentStatus", this.internalDocumentStatus);
        this.internalDocumentStatus = internalDocumentStatus;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentIsTopVersion</b>
     * </p>
     *
     * @param lglCntntMDocumentIsTopVersion
     *            Data element for domain BOOLE: TRUE (='X') and FALSE (=' ')
     */
    public void setLglCntntMDocumentIsTopVersion( @Nullable final Boolean lglCntntMDocumentIsTopVersion )
    {
        rememberChangedField("LglCntntMDocumentIsTopVersion", this.lglCntntMDocumentIsTopVersion);
        this.lglCntntMDocumentIsTopVersion = lglCntntMDocumentIsTopVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 36
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMVirtualDocVersKey</b>
     * </p>
     *
     * @param lglCntntMVirtualDocVersKey
     *            Virtual Document Version Key
     */
    public void setLglCntntMVirtualDocVersKey( @Nullable final String lglCntntMVirtualDocVersKey )
    {
        rememberChangedField("LglCntntMVirtualDocVersKey", this.lglCntntMVirtualDocVersKey);
        this.lglCntntMVirtualDocVersKey = lglCntntMVirtualDocVersKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocAssemblyStatus</b>
     * </p>
     *
     * @param lglCntntMDocAssemblyStatus
     *            Document Assembly Status
     */
    public void setLglCntntMDocAssemblyStatus( @Nullable final String lglCntntMDocAssemblyStatus )
    {
        rememberChangedField("LglCntntMDocAssemblyStatus", this.lglCntntMDocAssemblyStatus);
        this.lglCntntMDocAssemblyStatus = lglCntntMDocAssemblyStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMTmplID</b>
     * </p>
     *
     * @param lglCntntMTmplID
     *            Template ID
     */
    public void setLglCntntMTmplID( @Nullable final String lglCntntMTmplID )
    {
        rememberChangedField("LglCntntMTmplID", this.lglCntntMTmplID);
        this.lglCntntMTmplID = lglCntntMTmplID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocType</b>
     * </p>
     *
     * @param lglCntntMDocType
     *            Document Type
     */
    public void setLglCntntMDocType( @Nullable final String lglCntntMDocType )
    {
        rememberChangedField("LglCntntMDocType", this.lglCntntMDocType);
        this.lglCntntMDocType = lglCntntMDocType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocLowTouchLevel</b>
     * </p>
     *
     * @param lglCntntMDocLowTouchLevel
     *            Indicates the Assembly Automation Level of a Document
     */
    public void setLglCntntMDocLowTouchLevel( @Nullable final String lglCntntMDocLowTouchLevel )
    {
        rememberChangedField("LglCntntMDocLowTouchLevel", this.lglCntntMDocLowTouchLevel);
        this.lglCntntMDocLowTouchLevel = lglCntntMDocLowTouchLevel;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LegalDocument";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMDocumentUUID", getLglCntntMDocumentUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMDocumentUUID", getLglCntntMDocumentUUID());
        values.put("LglCntntMDocument", getLglCntntMDocument());
        values.put("LglCntntMDocumentLinkedObject", getLglCntntMDocumentLinkedObject());
        values.put("LglCntntMDocumentLinkedObjKey", getLglCntntMDocumentLinkedObjKey());
        values.put("LegalTransaction", getLegalTransaction());
        values.put("LglCntntMDocContentType", getLglCntntMDocContentType());
        values.put("LglCntntMLanguage", getLglCntntMLanguage());
        values.put("DocumentDescription", getDocumentDescription());
        values.put("LglCntntMDocAccessLvl", getLglCntntMDocAccessLvl());
        values.put("LegalDocumentSource", getLegalDocumentSource());
        values.put("LglCntntMChangedUTCDateTime", getLglCntntMChangedUTCDateTime());
        values.put("LglCntntMChangedByUser", getLglCntntMChangedByUser());
        values.put("LglCntntMCreatedUTCDateTime", getLglCntntMCreatedUTCDateTime());
        values.put("LglCntntMCreatedByUser", getLglCntntMCreatedByUser());
        values.put("InternalDocumentStatus", getInternalDocumentStatus());
        values.put("LglCntntMDocumentIsTopVersion", getLglCntntMDocumentIsTopVersion());
        values.put("LglCntntMVirtualDocVersKey", getLglCntntMVirtualDocVersKey());
        values.put("LglCntntMDocAssemblyStatus", getLglCntntMDocAssemblyStatus());
        values.put("LglCntntMTmplID", getLglCntntMTmplID());
        values.put("LglCntntMDocType", getLglCntntMDocType());
        values.put("LglCntntMDocLowTouchLevel", getLglCntntMDocLowTouchLevel());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMDocumentUUID") ) {
                final Object value = values.remove("LglCntntMDocumentUUID");
                if( (value == null) || (!value.equals(getLglCntntMDocumentUUID())) ) {
                    setLglCntntMDocumentUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMDocument") ) {
                final Object value = values.remove("LglCntntMDocument");
                if( (value == null) || (!value.equals(getLglCntntMDocument())) ) {
                    setLglCntntMDocument(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocumentLinkedObject") ) {
                final Object value = values.remove("LglCntntMDocumentLinkedObject");
                if( (value == null) || (!value.equals(getLglCntntMDocumentLinkedObject())) ) {
                    setLglCntntMDocumentLinkedObject(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocumentLinkedObjKey") ) {
                final Object value = values.remove("LglCntntMDocumentLinkedObjKey");
                if( (value == null) || (!value.equals(getLglCntntMDocumentLinkedObjKey())) ) {
                    setLglCntntMDocumentLinkedObjKey(((UUID) value));
                }
            }
            if( values.containsKey("LegalTransaction") ) {
                final Object value = values.remove("LegalTransaction");
                if( (value == null) || (!value.equals(getLegalTransaction())) ) {
                    setLegalTransaction(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocContentType") ) {
                final Object value = values.remove("LglCntntMDocContentType");
                if( (value == null) || (!value.equals(getLglCntntMDocContentType())) ) {
                    setLglCntntMDocContentType(((String) value));
                }
            }
            if( values.containsKey("LglCntntMLanguage") ) {
                final Object value = values.remove("LglCntntMLanguage");
                if( (value == null) || (!value.equals(getLglCntntMLanguage())) ) {
                    setLglCntntMLanguage(((String) value));
                }
            }
            if( values.containsKey("DocumentDescription") ) {
                final Object value = values.remove("DocumentDescription");
                if( (value == null) || (!value.equals(getDocumentDescription())) ) {
                    setDocumentDescription(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocAccessLvl") ) {
                final Object value = values.remove("LglCntntMDocAccessLvl");
                if( (value == null) || (!value.equals(getLglCntntMDocAccessLvl())) ) {
                    setLglCntntMDocAccessLvl(((String) value));
                }
            }
            if( values.containsKey("LegalDocumentSource") ) {
                final Object value = values.remove("LegalDocumentSource");
                if( (value == null) || (!value.equals(getLegalDocumentSource())) ) {
                    setLegalDocumentSource(((String) value));
                }
            }
            if( values.containsKey("LglCntntMChangedUTCDateTime") ) {
                final Object value = values.remove("LglCntntMChangedUTCDateTime");
                if( (value == null) || (!value.equals(getLglCntntMChangedUTCDateTime())) ) {
                    setLglCntntMChangedUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LglCntntMChangedByUser") ) {
                final Object value = values.remove("LglCntntMChangedByUser");
                if( (value == null) || (!value.equals(getLglCntntMChangedByUser())) ) {
                    setLglCntntMChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCreatedUTCDateTime") ) {
                final Object value = values.remove("LglCntntMCreatedUTCDateTime");
                if( (value == null) || (!value.equals(getLglCntntMCreatedUTCDateTime())) ) {
                    setLglCntntMCreatedUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LglCntntMCreatedByUser") ) {
                final Object value = values.remove("LglCntntMCreatedByUser");
                if( (value == null) || (!value.equals(getLglCntntMCreatedByUser())) ) {
                    setLglCntntMCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("InternalDocumentStatus") ) {
                final Object value = values.remove("InternalDocumentStatus");
                if( (value == null) || (!value.equals(getInternalDocumentStatus())) ) {
                    setInternalDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocumentIsTopVersion") ) {
                final Object value = values.remove("LglCntntMDocumentIsTopVersion");
                if( (value == null) || (!value.equals(getLglCntntMDocumentIsTopVersion())) ) {
                    setLglCntntMDocumentIsTopVersion(((Boolean) value));
                }
            }
            if( values.containsKey("LglCntntMVirtualDocVersKey") ) {
                final Object value = values.remove("LglCntntMVirtualDocVersKey");
                if( (value == null) || (!value.equals(getLglCntntMVirtualDocVersKey())) ) {
                    setLglCntntMVirtualDocVersKey(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocAssemblyStatus") ) {
                final Object value = values.remove("LglCntntMDocAssemblyStatus");
                if( (value == null) || (!value.equals(getLglCntntMDocAssemblyStatus())) ) {
                    setLglCntntMDocAssemblyStatus(((String) value));
                }
            }
            if( values.containsKey("LglCntntMTmplID") ) {
                final Object value = values.remove("LglCntntMTmplID");
                if( (value == null) || (!value.equals(getLglCntntMTmplID())) ) {
                    setLglCntntMTmplID(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocType") ) {
                final Object value = values.remove("LglCntntMDocType");
                if( (value == null) || (!value.equals(getLglCntntMDocType())) ) {
                    setLglCntntMDocType(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocLowTouchLevel") ) {
                final Object value = values.remove("LglCntntMDocLowTouchLevel");
                if( (value == null) || (!value.equals(getLglCntntMDocLowTouchLevel())) ) {
                    setLglCntntMDocLowTouchLevel(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LglCntntMDocParCategory") ) {
                final Object value = (values).remove("to_LglCntntMDocParCategory");
                if( value instanceof Iterable ) {
                    if( toLglCntntMDocParCategory == null ) {
                        toLglCntntMDocParCategory = Lists.newArrayList();
                    } else {
                        toLglCntntMDocParCategory = Lists.newArrayList(toLglCntntMDocParCategory);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglCntntMDocParCategory entity;
                        if( toLglCntntMDocParCategory.size() > i ) {
                            entity = toLglCntntMDocParCategory.get(i);
                        } else {
                            entity = new LglCntntMDocParCategory();
                            toLglCntntMDocParCategory.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LglDocStamp") ) {
                final Object value = (values).remove("to_LglDocStamp");
                if( value instanceof Iterable ) {
                    if( toLglDocStamp == null ) {
                        toLglDocStamp = Lists.newArrayList();
                    } else {
                        toLglDocStamp = Lists.newArrayList(toLglDocStamp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglDocStamp entity;
                        if( toLglDocStamp.size() > i ) {
                            entity = toLglDocStamp.get(i);
                        } else {
                            entity = new LglDocStamp();
                            toLglDocStamp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LegalDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LegalDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LegalDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LegalDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLglCntntMDocParCategory != null ) {
            (values).put("to_LglCntntMDocParCategory", toLglCntntMDocParCategory);
        }
        if( toLglDocStamp != null ) {
            (values).put("to_LglDocStamp", toLglDocStamp);
        }
        return values;
    }

    /**
     * Fetches the <b>LglCntntMDocParCategory</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_LglCntntMDocParCategory</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglCntntMDocParCategory</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglCntntMDocParCategory> fetchLglCntntMDocParCategory()
    {
        return fetchFieldAsList("to_LglCntntMDocParCategory", LglCntntMDocParCategory.class);
    }

    /**
     * Retrieval of associated <b>LglCntntMDocParCategory</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglCntntMDocParCategory</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocParCategory</b> of a queried <b>LegalDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglCntntMDocParCategory</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglCntntMDocParCategory> getLglCntntMDocParCategoryOrFetch()
    {
        if( toLglCntntMDocParCategory == null ) {
            toLglCntntMDocParCategory = fetchLglCntntMDocParCategory();
        }
        return toLglCntntMDocParCategory;
    }

    /**
     * Retrieval of associated <b>LglCntntMDocParCategory</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglCntntMDocParCategory</b>.
     * <p>
     * If the navigation property for an entity <b>LegalDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglCntntMDocParCategory</b> is already loaded, the
     *         result will contain the <b>LglCntntMDocParCategory</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglCntntMDocParCategory>> getLglCntntMDocParCategoryIfPresent()
    {
        return Option.of(toLglCntntMDocParCategory);
    }

    /**
     * Overwrites the list of associated <b>LglCntntMDocParCategory</b> entities for the loaded navigation property
     * <b>to_LglCntntMDocParCategory</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocParCategory</b> of a queried <b>LegalDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglCntntMDocParCategory</b> entities.
     */
    public void setLglCntntMDocParCategory( @Nonnull final List<LglCntntMDocParCategory> value )
    {
        if( toLglCntntMDocParCategory == null ) {
            toLglCntntMDocParCategory = Lists.newArrayList();
        }
        toLglCntntMDocParCategory.clear();
        toLglCntntMDocParCategory.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglCntntMDocParCategory</b> entities. This corresponds to the OData
     * navigation property <b>to_LglCntntMDocParCategory</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocParCategory</b> of a queried <b>LegalDocument</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglCntntMDocParCategory</b> entities.
     */
    public void addLglCntntMDocParCategory( LglCntntMDocParCategory... entity )
    {
        if( toLglCntntMDocParCategory == null ) {
            toLglCntntMDocParCategory = Lists.newArrayList();
        }
        toLglCntntMDocParCategory.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>LglDocStamp</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_LglDocStamp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglDocStamp</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglDocStamp> fetchLglDocStamp()
    {
        return fetchFieldAsList("to_LglDocStamp", LglDocStamp.class);
    }

    /**
     * Retrieval of associated <b>LglDocStamp</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LglDocStamp</b>.
     * <p>
     * If the navigation property <b>to_LglDocStamp</b> of a queried <b>LegalDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglDocStamp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglDocStamp> getLglDocStampOrFetch()
    {
        if( toLglDocStamp == null ) {
            toLglDocStamp = fetchLglDocStamp();
        }
        return toLglDocStamp;
    }

    /**
     * Retrieval of associated <b>LglDocStamp</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_LglDocStamp</b>.
     * <p>
     * If the navigation property for an entity <b>LegalDocument</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglDocStamp</b> is already loaded, the result will
     *         contain the <b>LglDocStamp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglDocStamp>> getLglDocStampIfPresent()
    {
        return Option.of(toLglDocStamp);
    }

    /**
     * Overwrites the list of associated <b>LglDocStamp</b> entities for the loaded navigation property
     * <b>to_LglDocStamp</b>.
     * <p>
     * If the navigation property <b>to_LglDocStamp</b> of a queried <b>LegalDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglDocStamp</b> entities.
     */
    public void setLglDocStamp( @Nonnull final List<LglDocStamp> value )
    {
        if( toLglDocStamp == null ) {
            toLglDocStamp = Lists.newArrayList();
        }
        toLglDocStamp.clear();
        toLglDocStamp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglDocStamp</b> entities. This corresponds to the OData navigation
     * property <b>to_LglDocStamp</b>.
     * <p>
     * If the navigation property <b>to_LglDocStamp</b> of a queried <b>LegalDocument</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglDocStamp</b> entities.
     */
    public void addLglDocStamp( LglDocStamp... entity )
    {
        if( toLglDocStamp == null ) {
            toLglDocStamp = Lists.newArrayList();
        }
        toLglDocStamp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LegalDocument instances.
     *
     */
    public final static class LegalDocumentBuilder
    {

        private List<LglCntntMDocParCategory> toLglCntntMDocParCategory = Lists.newArrayList();
        private List<LglDocStamp> toLglDocStamp = Lists.newArrayList();

        private LegalDocument.LegalDocumentBuilder toLglCntntMDocParCategory(
            final List<LglCntntMDocParCategory> value )
        {
            toLglCntntMDocParCategory.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglCntntMDocParCategory</b> for <b>LegalDocument</b> to multiple
         * <b>LglCntntMDocParCategory</b>.
         *
         * @param value
         *            The LglCntntMDocParCategorys to build this LegalDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalDocument.LegalDocumentBuilder lglCntntMDocParCategory( LglCntntMDocParCategory... value )
        {
            return toLglCntntMDocParCategory(Lists.newArrayList(value));
        }

        private LegalDocument.LegalDocumentBuilder toLglDocStamp( final List<LglDocStamp> value )
        {
            toLglDocStamp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglDocStamp</b> for <b>LegalDocument</b> to multiple <b>LglDocStamp</b>.
         *
         * @param value
         *            The LglDocStamps to build this LegalDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalDocument.LegalDocumentBuilder lglDocStamp( LglDocStamp... value )
        {
            return toLglDocStamp(Lists.newArrayList(value));
        }

    }

}
