/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.field.LglCntntMDocCategoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.selectable.LglCntntMDocCategorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Legal Document Category
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglCntntMDocCategoryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglCntntMDocCategory extends VdmEntity<LglCntntMDocCategory>
{

    /**
     * Selector for all available fields of LglCntntMDocCategory.
     *
     */
    public final static LglCntntMDocCategorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocCategoryUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LglCntntMDocCategoryUUID" )
    @JsonProperty( "LglCntntMDocCategoryUUID" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocCategoryUUID" )
    private UUID lglCntntMDocCategoryUUID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocCategoryUUID</b> field to query operations.
     *
     */
    public final static LglCntntMDocCategoryField<UUID> LGL_CNTNT_M_DOC_CATEGORY_UUID =
        new LglCntntMDocCategoryField<UUID>("LglCntntMDocCategoryUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocParCatUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LglCntntMDocParCatUUID" )
    @JsonProperty( "LglCntntMDocParCatUUID" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocParCatUUID" )
    private UUID lglCntntMDocParCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocParCatUUID</b> field to query operations.
     *
     */
    public final static LglCntntMDocCategoryField<UUID> LGL_CNTNT_M_DOC_PAR_CAT_UUID =
        new LglCntntMDocCategoryField<UUID>("LglCntntMDocParCatUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LglCntntMDocumentUUID" )
    @JsonProperty( "LglCntntMDocumentUUID" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocumentUUID" )
    private UUID lglCntntMDocumentUUID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocumentUUID</b> field to query operations.
     *
     */
    public final static LglCntntMDocCategoryField<UUID> LGL_CNTNT_M_DOCUMENT_UUID =
        new LglCntntMDocCategoryField<UUID>("LglCntntMDocumentUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategory</b>
     * </p>
     *
     * @return Category ID
     */
    @SerializedName( "LglCntntMCategory" )
    @JsonProperty( "LglCntntMCategory" )
    @Nullable
    @ODataField( odataName = "LglCntntMCategory" )
    private String lglCntntMCategory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCategory</b> field to query operations.
     *
     */
    public final static LglCntntMDocCategoryField<String> LGL_CNTNT_M_CATEGORY =
        new LglCntntMDocCategoryField<String>("LglCntntMCategory");

    @Nonnull
    @Override
    public Class<LglCntntMDocCategory> getType()
    {
        return LglCntntMDocCategory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocCategoryUUID</b>
     * </p>
     *
     * @param lglCntntMDocCategoryUUID
     *            Universal Unique Identifier
     */
    public void setLglCntntMDocCategoryUUID( @Nullable final UUID lglCntntMDocCategoryUUID )
    {
        rememberChangedField("LglCntntMDocCategoryUUID", this.lglCntntMDocCategoryUUID);
        this.lglCntntMDocCategoryUUID = lglCntntMDocCategoryUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocParCatUUID</b>
     * </p>
     *
     * @param lglCntntMDocParCatUUID
     *            Universal Unique Identifier
     */
    public void setLglCntntMDocParCatUUID( @Nullable final UUID lglCntntMDocParCatUUID )
    {
        rememberChangedField("LglCntntMDocParCatUUID", this.lglCntntMDocParCatUUID);
        this.lglCntntMDocParCatUUID = lglCntntMDocParCatUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentUUID</b>
     * </p>
     *
     * @param lglCntntMDocumentUUID
     *            Universal Unique Identifier
     */
    public void setLglCntntMDocumentUUID( @Nullable final UUID lglCntntMDocumentUUID )
    {
        rememberChangedField("LglCntntMDocumentUUID", this.lglCntntMDocumentUUID);
        this.lglCntntMDocumentUUID = lglCntntMDocumentUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCategory</b>
     * </p>
     *
     * @param lglCntntMCategory
     *            Category ID
     */
    public void setLglCntntMCategory( @Nullable final String lglCntntMCategory )
    {
        rememberChangedField("LglCntntMCategory", this.lglCntntMCategory);
        this.lglCntntMCategory = lglCntntMCategory;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglCntntMDocCategory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMDocCategoryUUID", getLglCntntMDocCategoryUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMDocCategoryUUID", getLglCntntMDocCategoryUUID());
        values.put("LglCntntMDocParCatUUID", getLglCntntMDocParCatUUID());
        values.put("LglCntntMDocumentUUID", getLglCntntMDocumentUUID());
        values.put("LglCntntMCategory", getLglCntntMCategory());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMDocCategoryUUID") ) {
                final Object value = values.remove("LglCntntMDocCategoryUUID");
                if( (value == null) || (!value.equals(getLglCntntMDocCategoryUUID())) ) {
                    setLglCntntMDocCategoryUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMDocParCatUUID") ) {
                final Object value = values.remove("LglCntntMDocParCatUUID");
                if( (value == null) || (!value.equals(getLglCntntMDocParCatUUID())) ) {
                    setLglCntntMDocParCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMDocumentUUID") ) {
                final Object value = values.remove("LglCntntMDocumentUUID");
                if( (value == null) || (!value.equals(getLglCntntMDocumentUUID())) ) {
                    setLglCntntMDocumentUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMCategory") ) {
                final Object value = values.remove("LglCntntMCategory");
                if( (value == null) || (!value.equals(getLglCntntMCategory())) ) {
                    setLglCntntMCategory(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglCntntMDocCategoryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglCntntMDocCategoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglCntntMDocCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglCntntMDocCategoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService.DEFAULT_SERVICE_PATH);
    }

}
