/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.field.LglCntntMDocParCategoryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.link.LglCntntMDocParCategoryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.selectable.LglCntntMDocParCategorySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Legal Document Parent Category
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglCntntMDocParCategoryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglCntntMDocParCategory extends VdmEntity<LglCntntMDocParCategory>
{

    /**
     * Selector for all available fields of LglCntntMDocParCategory.
     *
     */
    public final static LglCntntMDocParCategorySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocParCatUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LglCntntMDocParCatUUID" )
    @JsonProperty( "LglCntntMDocParCatUUID" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocParCatUUID" )
    private UUID lglCntntMDocParCatUUID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocParCatUUID</b> field to query operations.
     *
     */
    public final static LglCntntMDocParCategoryField<UUID> LGL_CNTNT_M_DOC_PAR_CAT_UUID =
        new LglCntntMDocParCategoryField<UUID>("LglCntntMDocParCatUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LglCntntMDocumentUUID" )
    @JsonProperty( "LglCntntMDocumentUUID" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocumentUUID" )
    private UUID lglCntntMDocumentUUID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocumentUUID</b> field to query operations.
     *
     */
    public final static LglCntntMDocParCategoryField<UUID> LGL_CNTNT_M_DOCUMENT_UUID =
        new LglCntntMDocParCategoryField<UUID>("LglCntntMDocumentUUID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMParentCategory</b>
     * </p>
     *
     * @return Parent Category ID
     */
    @SerializedName( "LglCntntMParentCategory" )
    @JsonProperty( "LglCntntMParentCategory" )
    @Nullable
    @ODataField( odataName = "LglCntntMParentCategory" )
    private String lglCntntMParentCategory;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMParentCategory</b> field to query operations.
     *
     */
    public final static LglCntntMDocParCategoryField<String> LGL_CNTNT_M_PARENT_CATEGORY =
        new LglCntntMDocParCategoryField<String>("LglCntntMParentCategory");
    /**
     * Navigation property <b>to_LglCntntMDocCategory</b> for <b>LglCntntMDocParCategory</b> to multiple
     * <b>LglCntntMDocCategory</b>.
     *
     */
    @SerializedName( "to_LglCntntMDocCategory" )
    @JsonProperty( "to_LglCntntMDocCategory" )
    @ODataField( odataName = "to_LglCntntMDocCategory" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglCntntMDocCategory> toLglCntntMDocCategory;
    /**
     * Use with available fluent helpers to apply the <b>to_LglCntntMDocCategory</b> navigation property to query
     * operations.
     *
     */
    public final static LglCntntMDocParCategoryLink<LglCntntMDocCategory> TO_LGL_CNTNT_M_DOC_CATEGORY =
        new LglCntntMDocParCategoryLink<LglCntntMDocCategory>("to_LglCntntMDocCategory");

    @Nonnull
    @Override
    public Class<LglCntntMDocParCategory> getType()
    {
        return LglCntntMDocParCategory.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocParCatUUID</b>
     * </p>
     *
     * @param lglCntntMDocParCatUUID
     *            Universal Unique Identifier
     */
    public void setLglCntntMDocParCatUUID( @Nullable final UUID lglCntntMDocParCatUUID )
    {
        rememberChangedField("LglCntntMDocParCatUUID", this.lglCntntMDocParCatUUID);
        this.lglCntntMDocParCatUUID = lglCntntMDocParCatUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentUUID</b>
     * </p>
     *
     * @param lglCntntMDocumentUUID
     *            Universal Unique Identifier
     */
    public void setLglCntntMDocumentUUID( @Nullable final UUID lglCntntMDocumentUUID )
    {
        rememberChangedField("LglCntntMDocumentUUID", this.lglCntntMDocumentUUID);
        this.lglCntntMDocumentUUID = lglCntntMDocumentUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMParentCategory</b>
     * </p>
     *
     * @param lglCntntMParentCategory
     *            Parent Category ID
     */
    public void setLglCntntMParentCategory( @Nullable final String lglCntntMParentCategory )
    {
        rememberChangedField("LglCntntMParentCategory", this.lglCntntMParentCategory);
        this.lglCntntMParentCategory = lglCntntMParentCategory;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglCntntMDocParCategory";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMDocParCatUUID", getLglCntntMDocParCatUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMDocParCatUUID", getLglCntntMDocParCatUUID());
        values.put("LglCntntMDocumentUUID", getLglCntntMDocumentUUID());
        values.put("LglCntntMParentCategory", getLglCntntMParentCategory());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMDocParCatUUID") ) {
                final Object value = values.remove("LglCntntMDocParCatUUID");
                if( (value == null) || (!value.equals(getLglCntntMDocParCatUUID())) ) {
                    setLglCntntMDocParCatUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMDocumentUUID") ) {
                final Object value = values.remove("LglCntntMDocumentUUID");
                if( (value == null) || (!value.equals(getLglCntntMDocumentUUID())) ) {
                    setLglCntntMDocumentUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMParentCategory") ) {
                final Object value = values.remove("LglCntntMParentCategory");
                if( (value == null) || (!value.equals(getLglCntntMParentCategory())) ) {
                    setLglCntntMParentCategory(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LglCntntMDocCategory") ) {
                final Object value = (values).remove("to_LglCntntMDocCategory");
                if( value instanceof Iterable ) {
                    if( toLglCntntMDocCategory == null ) {
                        toLglCntntMDocCategory = Lists.newArrayList();
                    } else {
                        toLglCntntMDocCategory = Lists.newArrayList(toLglCntntMDocCategory);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglCntntMDocCategory entity;
                        if( toLglCntntMDocCategory.size() > i ) {
                            entity = toLglCntntMDocCategory.get(i);
                        } else {
                            entity = new LglCntntMDocCategory();
                            toLglCntntMDocCategory.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglCntntMDocParCategoryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglCntntMDocParCategoryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglCntntMDocParCategoryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglCntntMDocParCategoryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLglCntntMDocCategory != null ) {
            (values).put("to_LglCntntMDocCategory", toLglCntntMDocCategory);
        }
        return values;
    }

    /**
     * Fetches the <b>LglCntntMDocCategory</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_LglCntntMDocCategory</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglCntntMDocCategory</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglCntntMDocCategory> fetchLglCntntMDocCategory()
    {
        return fetchFieldAsList("to_LglCntntMDocCategory", LglCntntMDocCategory.class);
    }

    /**
     * Retrieval of associated <b>LglCntntMDocCategory</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglCntntMDocCategory</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocCategory</b> of a queried <b>LglCntntMDocParCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglCntntMDocCategory</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglCntntMDocCategory> getLglCntntMDocCategoryOrFetch()
    {
        if( toLglCntntMDocCategory == null ) {
            toLglCntntMDocCategory = fetchLglCntntMDocCategory();
        }
        return toLglCntntMDocCategory;
    }

    /**
     * Retrieval of associated <b>LglCntntMDocCategory</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglCntntMDocCategory</b>.
     * <p>
     * If the navigation property for an entity <b>LglCntntMDocParCategory</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglCntntMDocCategory</b> is already loaded, the result
     *         will contain the <b>LglCntntMDocCategory</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglCntntMDocCategory>> getLglCntntMDocCategoryIfPresent()
    {
        return Option.of(toLglCntntMDocCategory);
    }

    /**
     * Overwrites the list of associated <b>LglCntntMDocCategory</b> entities for the loaded navigation property
     * <b>to_LglCntntMDocCategory</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocCategory</b> of a queried <b>LglCntntMDocParCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglCntntMDocCategory</b> entities.
     */
    public void setLglCntntMDocCategory( @Nonnull final List<LglCntntMDocCategory> value )
    {
        if( toLglCntntMDocCategory == null ) {
            toLglCntntMDocCategory = Lists.newArrayList();
        }
        toLglCntntMDocCategory.clear();
        toLglCntntMDocCategory.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglCntntMDocCategory</b> entities. This corresponds to the OData
     * navigation property <b>to_LglCntntMDocCategory</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocCategory</b> of a queried <b>LglCntntMDocParCategory</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglCntntMDocCategory</b> entities.
     */
    public void addLglCntntMDocCategory( LglCntntMDocCategory... entity )
    {
        if( toLglCntntMDocCategory == null ) {
            toLglCntntMDocCategory = Lists.newArrayList();
        }
        toLglCntntMDocCategory.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LglCntntMDocParCategory instances.
     *
     */
    public final static class LglCntntMDocParCategoryBuilder
    {

        private List<LglCntntMDocCategory> toLglCntntMDocCategory = Lists.newArrayList();

        private LglCntntMDocParCategory.LglCntntMDocParCategoryBuilder toLglCntntMDocCategory(
            final List<LglCntntMDocCategory> value )
        {
            toLglCntntMDocCategory.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglCntntMDocCategory</b> for <b>LglCntntMDocParCategory</b> to multiple
         * <b>LglCntntMDocCategory</b>.
         *
         * @param value
         *            The LglCntntMDocCategorys to build this LglCntntMDocParCategory with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LglCntntMDocParCategory.LglCntntMDocParCategoryBuilder lglCntntMDocCategory(
            LglCntntMDocCategory... value )
        {
            return toLglCntntMDocCategory(Lists.newArrayList(value));
        }

    }

}
