/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.field.LglDocStampField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.selectable.LglDocStampSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Legal Document Stamp
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglDocStampType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglDocStamp extends VdmEntity<LglDocStamp>
{

    /**
     * Selector for all available fields of LglDocStamp.
     *
     */
    public final static LglDocStampSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentStampUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @Key
    @SerializedName( "LglCntntMDocumentStampUUID" )
    @JsonProperty( "LglCntntMDocumentStampUUID" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocumentStampUUID" )
    private UUID lglCntntMDocumentStampUUID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocumentStampUUID</b> field to query operations.
     *
     */
    public final static LglDocStampField<UUID> LGL_CNTNT_M_DOCUMENT_STAMP_UUID =
        new LglDocStampField<UUID>("LglCntntMDocumentStampUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentUUID</b>
     * </p>
     *
     * @return Universal Unique Identifier
     */
    @SerializedName( "LglCntntMDocumentUUID" )
    @JsonProperty( "LglCntntMDocumentUUID" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocumentUUID" )
    private UUID lglCntntMDocumentUUID;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocumentUUID</b> field to query operations.
     *
     */
    public final static LglDocStampField<UUID> LGL_CNTNT_M_DOCUMENT_UUID =
        new LglDocStampField<UUID>("LglCntntMDocumentUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentStamp</b>
     * </p>
     *
     * @return Document Stamp Name
     */
    @SerializedName( "LglCntntMDocumentStamp" )
    @JsonProperty( "LglCntntMDocumentStamp" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocumentStamp" )
    private String lglCntntMDocumentStamp;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocumentStamp</b> field to query operations.
     *
     */
    public final static LglDocStampField<String> LGL_CNTNT_M_DOCUMENT_STAMP =
        new LglDocStampField<String>("LglCntntMDocumentStamp");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedUTCDateTime</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "LglCntntMCreatedUTCDateTime" )
    @JsonProperty( "LglCntntMCreatedUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LglCntntMCreatedUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lglCntntMCreatedUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCreatedUTCDateTime</b> field to query operations.
     *
     */
    public final static LglDocStampField<ZonedDateTime> LGL_CNTNT_M_CREATED_UTC_DATE_TIME =
        new LglDocStampField<ZonedDateTime>("LglCntntMCreatedUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "LglCntntMCreatedByUser" )
    @JsonProperty( "LglCntntMCreatedByUser" )
    @Nullable
    @ODataField( odataName = "LglCntntMCreatedByUser" )
    private String lglCntntMCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMCreatedByUser</b> field to query operations.
     *
     */
    public final static LglDocStampField<String> LGL_CNTNT_M_CREATED_BY_USER =
        new LglDocStampField<String>("LglCntntMCreatedByUser");

    @Nonnull
    @Override
    public Class<LglDocStamp> getType()
    {
        return LglDocStamp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentStampUUID</b>
     * </p>
     *
     * @param lglCntntMDocumentStampUUID
     *            Universal Unique Identifier
     */
    public void setLglCntntMDocumentStampUUID( @Nullable final UUID lglCntntMDocumentStampUUID )
    {
        rememberChangedField("LglCntntMDocumentStampUUID", this.lglCntntMDocumentStampUUID);
        this.lglCntntMDocumentStampUUID = lglCntntMDocumentStampUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentUUID</b>
     * </p>
     *
     * @param lglCntntMDocumentUUID
     *            Universal Unique Identifier
     */
    public void setLglCntntMDocumentUUID( @Nullable final UUID lglCntntMDocumentUUID )
    {
        rememberChangedField("LglCntntMDocumentUUID", this.lglCntntMDocumentUUID);
        this.lglCntntMDocumentUUID = lglCntntMDocumentUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocumentStamp</b>
     * </p>
     *
     * @param lglCntntMDocumentStamp
     *            Document Stamp Name
     */
    public void setLglCntntMDocumentStamp( @Nullable final String lglCntntMDocumentStamp )
    {
        rememberChangedField("LglCntntMDocumentStamp", this.lglCntntMDocumentStamp);
        this.lglCntntMDocumentStamp = lglCntntMDocumentStamp;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedUTCDateTime</b>
     * </p>
     *
     * @param lglCntntMCreatedUTCDateTime
     *            Created On
     */
    public void setLglCntntMCreatedUTCDateTime( @Nullable final ZonedDateTime lglCntntMCreatedUTCDateTime )
    {
        rememberChangedField("LglCntntMCreatedUTCDateTime", this.lglCntntMCreatedUTCDateTime);
        this.lglCntntMCreatedUTCDateTime = lglCntntMCreatedUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMCreatedByUser</b>
     * </p>
     *
     * @param lglCntntMCreatedByUser
     *            Created By
     */
    public void setLglCntntMCreatedByUser( @Nullable final String lglCntntMCreatedByUser )
    {
        rememberChangedField("LglCntntMCreatedByUser", this.lglCntntMCreatedByUser);
        this.lglCntntMCreatedByUser = lglCntntMCreatedByUser;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglDocStamp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMDocumentStampUUID", getLglCntntMDocumentStampUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMDocumentStampUUID", getLglCntntMDocumentStampUUID());
        values.put("LglCntntMDocumentUUID", getLglCntntMDocumentUUID());
        values.put("LglCntntMDocumentStamp", getLglCntntMDocumentStamp());
        values.put("LglCntntMCreatedUTCDateTime", getLglCntntMCreatedUTCDateTime());
        values.put("LglCntntMCreatedByUser", getLglCntntMCreatedByUser());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMDocumentStampUUID") ) {
                final Object value = values.remove("LglCntntMDocumentStampUUID");
                if( (value == null) || (!value.equals(getLglCntntMDocumentStampUUID())) ) {
                    setLglCntntMDocumentStampUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMDocumentUUID") ) {
                final Object value = values.remove("LglCntntMDocumentUUID");
                if( (value == null) || (!value.equals(getLglCntntMDocumentUUID())) ) {
                    setLglCntntMDocumentUUID(((UUID) value));
                }
            }
            if( values.containsKey("LglCntntMDocumentStamp") ) {
                final Object value = values.remove("LglCntntMDocumentStamp");
                if( (value == null) || (!value.equals(getLglCntntMDocumentStamp())) ) {
                    setLglCntntMDocumentStamp(((String) value));
                }
            }
            if( values.containsKey("LglCntntMCreatedUTCDateTime") ) {
                final Object value = values.remove("LglCntntMCreatedUTCDateTime");
                if( (value == null) || (!value.equals(getLglCntntMCreatedUTCDateTime())) ) {
                    setLglCntntMCreatedUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LglCntntMCreatedByUser") ) {
                final Object value = values.remove("LglCntntMCreatedByUser");
                if( (value == null) || (!value.equals(getLglCntntMCreatedByUser())) ) {
                    setLglCntntMCreatedByUser(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LglDocStampField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglDocStampField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglDocStampField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglDocStampField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService.DEFAULT_SERVICE_PATH);
    }

}
