/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link LegalDocumentServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService LegalDocumentService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultLegalDocumentServiceBatch
    extends
    BatchFluentHelperBasic<LegalDocumentServiceBatch, LegalDocumentServiceBatchChangeSet>
    implements
    LegalDocumentServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultLegalDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultLegalDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultLegalDocumentServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LegalDocumentServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultLegalDocumentServiceBatchChangeSet(this, service);
    }

}
