/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp;

/**
 * Implementation of the {@link LegalDocumentServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService LegalDocumentService}.
 *
 */
public class DefaultLegalDocumentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<LegalDocumentServiceBatch, LegalDocumentServiceBatchChangeSet>
    implements
    LegalDocumentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService service;

    @SuppressWarnings( "deprecation" )
    DefaultLegalDocumentServiceBatchChangeSet(
        @Nonnull final DefaultLegalDocumentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultLegalDocumentServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LegalDocumentServiceBatchChangeSet createLegalDocument( @Nonnull final LegalDocument legalDocument )
    {
        return addRequestCreate(service::createLegalDocument, legalDocument);
    }

    @Nonnull
    @Override
    public LegalDocumentServiceBatchChangeSet createLglCntntMDocCategory(
        @Nonnull final LglCntntMDocCategory lglCntntMDocCategory )
    {
        return addRequestCreate(service::createLglCntntMDocCategory, lglCntntMDocCategory);
    }

    @Nonnull
    @Override
    public LegalDocumentServiceBatchChangeSet createLglCntntMDocParCategory(
        @Nonnull final LglCntntMDocParCategory lglCntntMDocParCategory )
    {
        return addRequestCreate(service::createLglCntntMDocParCategory, lglCntntMDocParCategory);
    }

    @Nonnull
    @Override
    public LegalDocumentServiceBatchChangeSet createLglDocStamp( @Nonnull final LglDocStamp lglDocStamp )
    {
        return addRequestCreate(service::createLglDocStamp, lglDocStamp);
    }

}
