/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentService LegalDocumentService}.
 *
 */
public interface LegalDocumentServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<LegalDocumentServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<LegalDocumentServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument
     * LegalDocument} entity and save it to the S/4HANA system.
     *
     * @param legalDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument LegalDocument}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalDocumentServiceBatchChangeSet createLegalDocument( @Nonnull final LegalDocument legalDocument );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory
     * LglCntntMDocCategory} entity and save it to the S/4HANA system.
     *
     * @param lglCntntMDocCategory
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory
     *            LglCntntMDocCategory} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalDocumentServiceBatchChangeSet
        createLglCntntMDocCategory( @Nonnull final LglCntntMDocCategory lglCntntMDocCategory );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
     * LglCntntMDocParCategory} entity and save it to the S/4HANA system.
     *
     * @param lglCntntMDocParCategory
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
     *            LglCntntMDocParCategory} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalDocumentServiceBatchChangeSet
        createLglCntntMDocParCategory( @Nonnull final LglCntntMDocParCategory lglCntntMDocParCategory );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp}
     * entity and save it to the S/4HANA system.
     *
     * @param lglDocStamp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    LegalDocumentServiceBatchChangeSet createLglDocStamp( @Nonnull final LglDocStamp lglDocStamp );

}
