/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument LegalDocument}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.field.LegalDocumentField
 * LegalDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.link.LegalDocumentLink LegalDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOCUMENT_UUID
 * LGL_CNTNT_M_DOCUMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOCUMENT
 * LGL_CNTNT_M_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOCUMENT_LINKED_OBJECT
 * LGL_CNTNT_M_DOCUMENT_LINKED_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOCUMENT_LINKED_OBJ_KEY
 * LGL_CNTNT_M_DOCUMENT_LINKED_OBJ_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LEGAL_TRANSACTION
 * LEGAL_TRANSACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOC_CONTENT_TYPE
 * LGL_CNTNT_M_DOC_CONTENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_LANGUAGE
 * LGL_CNTNT_M_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#DOCUMENT_DESCRIPTION
 * DOCUMENT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOC_ACCESS_LVL
 * LGL_CNTNT_M_DOC_ACCESS_LVL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LEGAL_DOCUMENT_SOURCE
 * LEGAL_DOCUMENT_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_CHANGED_UTC_DATE_TIME
 * LGL_CNTNT_M_CHANGED_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_CHANGED_BY_USER
 * LGL_CNTNT_M_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_CREATED_UTC_DATE_TIME
 * LGL_CNTNT_M_CREATED_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_CREATED_BY_USER
 * LGL_CNTNT_M_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#INTERNAL_DOCUMENT_STATUS
 * INTERNAL_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOCUMENT_IS_TOP_VERSION
 * LGL_CNTNT_M_DOCUMENT_IS_TOP_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_VIRTUAL_DOC_VERS_KEY
 * LGL_CNTNT_M_VIRTUAL_DOC_VERS_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOC_ASSEMBLY_STATUS
 * LGL_CNTNT_M_DOC_ASSEMBLY_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_TMPL_ID
 * LGL_CNTNT_M_TMPL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOC_TYPE
 * LGL_CNTNT_M_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#LGL_CNTNT_M_DOC_LOW_TOUCH_LEVEL
 * LGL_CNTNT_M_DOC_LOW_TOUCH_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#TO_LGL_CNTNT_M_DOC_PAR_CATEGORY
 * TO_LGL_CNTNT_M_DOC_PAR_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LegalDocument#TO_LGL_DOC_STAMP
 * TO_LGL_DOC_STAMP}</li>
 * </ul>
 *
 */
public interface LegalDocumentSelectable extends EntitySelectable<LegalDocument>
{

}
