/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory LglCntntMDocCategory}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.field.LglCntntMDocCategoryField
 * LglCntntMDocCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.link.LglCntntMDocCategoryLink
 * LglCntntMDocCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory#LGL_CNTNT_M_DOC_CATEGORY_UUID
 * LGL_CNTNT_M_DOC_CATEGORY_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory#LGL_CNTNT_M_DOC_PAR_CAT_UUID
 * LGL_CNTNT_M_DOC_PAR_CAT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory#LGL_CNTNT_M_DOCUMENT_UUID
 * LGL_CNTNT_M_DOCUMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocCategory#LGL_CNTNT_M_CATEGORY
 * LGL_CNTNT_M_CATEGORY}</li>
 * </ul>
 *
 */
public interface LglCntntMDocCategorySelectable extends EntitySelectable<LglCntntMDocCategory>
{

}
