/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory
 * LglCntntMDocParCategory}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.field.LglCntntMDocParCategoryField
 * LglCntntMDocParCategoryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.link.LglCntntMDocParCategoryLink
 * LglCntntMDocParCategoryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory#LGL_CNTNT_M_DOC_PAR_CAT_UUID
 * LGL_CNTNT_M_DOC_PAR_CAT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory#LGL_CNTNT_M_DOCUMENT_UUID
 * LGL_CNTNT_M_DOCUMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory#LGL_CNTNT_M_PARENT_CATEGORY
 * LGL_CNTNT_M_PARENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglCntntMDocParCategory#TO_LGL_CNTNT_M_DOC_CATEGORY
 * TO_LGL_CNTNT_M_DOC_CATEGORY}</li>
 * </ul>
 *
 */
public interface LglCntntMDocParCategorySelectable extends EntitySelectable<LglCntntMDocParCategory>
{

}
