/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp LglDocStamp}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.field.LglDocStampField
 * LglDocStampField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.link.LglDocStampLink
 * LglDocStampLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp#LGL_CNTNT_M_DOCUMENT_STAMP_UUID
 * LGL_CNTNT_M_DOCUMENT_STAMP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp#LGL_CNTNT_M_DOCUMENT_UUID
 * LGL_CNTNT_M_DOCUMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp#LGL_CNTNT_M_DOCUMENT_STAMP
 * LGL_CNTNT_M_DOCUMENT_STAMP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp#LGL_CNTNT_M_CREATED_UTC_DATE_TIME
 * LGL_CNTNT_M_CREATED_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocument.LglDocStamp#LGL_CNTNT_M_CREATED_BY_USER
 * LGL_CNTNT_M_CREATED_BY_USER}</li>
 * </ul>
 *
 */
public interface LglDocStampSelectable extends EntitySelectable<LglDocStamp>
{

}
