/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.field.LglCntntMAccessLvlField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.link.LglCntntMAccessLvlLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.selectable.LglCntntMAccessLvlSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Legal Document Access Levels
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglCntntMAccessLvlType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglCntntMAccessLvl extends VdmEntity<LglCntntMAccessLvl>
{

    /**
     * Selector for all available fields of LglCntntMAccessLvl.
     *
     */
    public final static LglCntntMAccessLvlSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMAccessLvl</b>
     * </p>
     *
     * @return Access Level
     */
    @Key
    @SerializedName( "LglCntntMAccessLvl" )
    @JsonProperty( "LglCntntMAccessLvl" )
    @Nullable
    @ODataField( odataName = "LglCntntMAccessLvl" )
    private String lglCntntMAccessLvl;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMAccessLvl</b> field to query operations.
     *
     */
    public final static LglCntntMAccessLvlField<String> LGL_CNTNT_M_ACCESS_LVL =
        new LglCntntMAccessLvlField<String>("LglCntntMAccessLvl");
    /**
     * Navigation property <b>to_AccessLevelText</b> for <b>LglCntntMAccessLvl</b> to multiple
     * <b>LglCntntMAccessLvlText</b>.
     *
     */
    @SerializedName( "to_AccessLevelText" )
    @JsonProperty( "to_AccessLevelText" )
    @ODataField( odataName = "to_AccessLevelText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglCntntMAccessLvlText> toAccessLevelText;
    /**
     * Use with available fluent helpers to apply the <b>to_AccessLevelText</b> navigation property to query operations.
     *
     */
    public final static LglCntntMAccessLvlLink<LglCntntMAccessLvlText> TO_ACCESS_LEVEL_TEXT =
        new LglCntntMAccessLvlLink<LglCntntMAccessLvlText>("to_AccessLevelText");

    @Nonnull
    @Override
    public Class<LglCntntMAccessLvl> getType()
    {
        return LglCntntMAccessLvl.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMAccessLvl</b>
     * </p>
     *
     * @param lglCntntMAccessLvl
     *            Access Level
     */
    public void setLglCntntMAccessLvl( @Nullable final String lglCntntMAccessLvl )
    {
        rememberChangedField("LglCntntMAccessLvl", this.lglCntntMAccessLvl);
        this.lglCntntMAccessLvl = lglCntntMAccessLvl;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglCntntMAccessLvl";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMAccessLvl", getLglCntntMAccessLvl());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMAccessLvl", getLglCntntMAccessLvl());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMAccessLvl") ) {
                final Object value = values.remove("LglCntntMAccessLvl");
                if( (value == null) || (!value.equals(getLglCntntMAccessLvl())) ) {
                    setLglCntntMAccessLvl(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_AccessLevelText") ) {
                final Object value = (values).remove("to_AccessLevelText");
                if( value instanceof Iterable ) {
                    if( toAccessLevelText == null ) {
                        toAccessLevelText = Lists.newArrayList();
                    } else {
                        toAccessLevelText = Lists.newArrayList(toAccessLevelText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglCntntMAccessLvlText entity;
                        if( toAccessLevelText.size() > i ) {
                            entity = toAccessLevelText.get(i);
                        } else {
                            entity = new LglCntntMAccessLvlText();
                            toAccessLevelText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglCntntMAccessLvlField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglCntntMAccessLvlField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglCntntMAccessLvlField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglCntntMAccessLvlField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAccessLevelText != null ) {
            (values).put("to_AccessLevelText", toAccessLevelText);
        }
        return values;
    }

    /**
     * Fetches the <b>LglCntntMAccessLvlText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_AccessLevelText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglCntntMAccessLvlText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglCntntMAccessLvlText> fetchAccessLevelText()
    {
        return fetchFieldAsList("to_AccessLevelText", LglCntntMAccessLvlText.class);
    }

    /**
     * Retrieval of associated <b>LglCntntMAccessLvlText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AccessLevelText</b>.
     * <p>
     * If the navigation property <b>to_AccessLevelText</b> of a queried <b>LglCntntMAccessLvl</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglCntntMAccessLvlText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglCntntMAccessLvlText> getAccessLevelTextOrFetch()
    {
        if( toAccessLevelText == null ) {
            toAccessLevelText = fetchAccessLevelText();
        }
        return toAccessLevelText;
    }

    /**
     * Retrieval of associated <b>LglCntntMAccessLvlText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_AccessLevelText</b>.
     * <p>
     * If the navigation property for an entity <b>LglCntntMAccessLvl</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_AccessLevelText</b> is already loaded, the result will
     *         contain the <b>LglCntntMAccessLvlText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglCntntMAccessLvlText>> getAccessLevelTextIfPresent()
    {
        return Option.of(toAccessLevelText);
    }

    /**
     * Overwrites the list of associated <b>LglCntntMAccessLvlText</b> entities for the loaded navigation property
     * <b>to_AccessLevelText</b>.
     * <p>
     * If the navigation property <b>to_AccessLevelText</b> of a queried <b>LglCntntMAccessLvl</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglCntntMAccessLvlText</b> entities.
     */
    public void setAccessLevelText( @Nonnull final List<LglCntntMAccessLvlText> value )
    {
        if( toAccessLevelText == null ) {
            toAccessLevelText = Lists.newArrayList();
        }
        toAccessLevelText.clear();
        toAccessLevelText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglCntntMAccessLvlText</b> entities. This corresponds to the OData
     * navigation property <b>to_AccessLevelText</b>.
     * <p>
     * If the navigation property <b>to_AccessLevelText</b> of a queried <b>LglCntntMAccessLvl</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglCntntMAccessLvlText</b> entities.
     */
    public void addAccessLevelText( LglCntntMAccessLvlText... entity )
    {
        if( toAccessLevelText == null ) {
            toAccessLevelText = Lists.newArrayList();
        }
        toAccessLevelText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LglCntntMAccessLvl instances.
     *
     */
    public final static class LglCntntMAccessLvlBuilder
    {

        private List<LglCntntMAccessLvlText> toAccessLevelText = Lists.newArrayList();

        private LglCntntMAccessLvl.LglCntntMAccessLvlBuilder toAccessLevelText(
            final List<LglCntntMAccessLvlText> value )
        {
            toAccessLevelText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_AccessLevelText</b> for <b>LglCntntMAccessLvl</b> to multiple
         * <b>LglCntntMAccessLvlText</b>.
         *
         * @param value
         *            The LglCntntMAccessLvlTexts to build this LglCntntMAccessLvl with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LglCntntMAccessLvl.LglCntntMAccessLvlBuilder accessLevelText( LglCntntMAccessLvlText... value )
        {
            return toAccessLevelText(Lists.newArrayList(value));
        }

    }

}
