/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.selectable.LglCntntMAccessLvlSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl
 * LglCntntMAccessLvl} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class LglCntntMAccessLvlByKeyFluentHelper
    extends
    FluentHelperByKey<LglCntntMAccessLvlByKeyFluentHelper, LglCntntMAccessLvl, LglCntntMAccessLvlSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl
     * LglCntntMAccessLvl} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LglCntntMAccessLvl}
     * @param servicePath
     *            Service path to be used to fetch a single {@code LglCntntMAccessLvl}
     * @param lglCntntMAccessLvl
     *            Access Level
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public LglCntntMAccessLvlByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String lglCntntMAccessLvl )
    {
        super(servicePath, entityCollection);
        this.key.put("LglCntntMAccessLvl", lglCntntMAccessLvl);
    }

    @Override
    @Nonnull
    protected Class<LglCntntMAccessLvl> getEntityClass()
    {
        return LglCntntMAccessLvl.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
