/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.field.LglCntntMAccessLvlTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.selectable.LglCntntMAccessLvlTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Access Level - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglCntntMAccessLvlTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglCntntMAccessLvlText extends VdmEntity<LglCntntMAccessLvlText>
{

    /**
     * Selector for all available fields of LglCntntMAccessLvlText.
     *
     */
    public final static LglCntntMAccessLvlTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMAccessLvl</b>
     * </p>
     *
     * @return Access Level
     */
    @Key
    @SerializedName( "LglCntntMAccessLvl" )
    @JsonProperty( "LglCntntMAccessLvl" )
    @Nullable
    @ODataField( odataName = "LglCntntMAccessLvl" )
    private String lglCntntMAccessLvl;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMAccessLvl</b> field to query operations.
     *
     */
    public final static LglCntntMAccessLvlTextField<String> LGL_CNTNT_M_ACCESS_LVL =
        new LglCntntMAccessLvlTextField<String>("LglCntntMAccessLvl");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static LglCntntMAccessLvlTextField<String> LANGUAGE =
        new LglCntntMAccessLvlTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMAccessLvlName</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "LglCntntMAccessLvlName" )
    @JsonProperty( "LglCntntMAccessLvlName" )
    @Nullable
    @ODataField( odataName = "LglCntntMAccessLvlName" )
    private String lglCntntMAccessLvlName;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMAccessLvlName</b> field to query operations.
     *
     */
    public final static LglCntntMAccessLvlTextField<String> LGL_CNTNT_M_ACCESS_LVL_NAME =
        new LglCntntMAccessLvlTextField<String>("LglCntntMAccessLvlName");

    @Nonnull
    @Override
    public Class<LglCntntMAccessLvlText> getType()
    {
        return LglCntntMAccessLvlText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMAccessLvl</b>
     * </p>
     *
     * @param lglCntntMAccessLvl
     *            Access Level
     */
    public void setLglCntntMAccessLvl( @Nullable final String lglCntntMAccessLvl )
    {
        rememberChangedField("LglCntntMAccessLvl", this.lglCntntMAccessLvl);
        this.lglCntntMAccessLvl = lglCntntMAccessLvl;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMAccessLvlName</b>
     * </p>
     *
     * @param lglCntntMAccessLvlName
     *            Long Text
     */
    public void setLglCntntMAccessLvlName( @Nullable final String lglCntntMAccessLvlName )
    {
        rememberChangedField("LglCntntMAccessLvlName", this.lglCntntMAccessLvlName);
        this.lglCntntMAccessLvlName = lglCntntMAccessLvlName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglCntntMAccessLvlText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMAccessLvl", getLglCntntMAccessLvl());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMAccessLvl", getLglCntntMAccessLvl());
        values.put("Language", getLanguage());
        values.put("LglCntntMAccessLvlName", getLglCntntMAccessLvlName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMAccessLvl") ) {
                final Object value = values.remove("LglCntntMAccessLvl");
                if( (value == null) || (!value.equals(getLglCntntMAccessLvl())) ) {
                    setLglCntntMAccessLvl(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LglCntntMAccessLvlName") ) {
                final Object value = values.remove("LglCntntMAccessLvlName");
                if( (value == null) || (!value.equals(getLglCntntMAccessLvlName())) ) {
                    setLglCntntMAccessLvlName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglCntntMAccessLvlTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglCntntMAccessLvlTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglCntntMAccessLvlTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglCntntMAccessLvlTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService.DEFAULT_SERVICE_PATH);
    }

}
