/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link LegalDocumentAccessLevelServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService
 * LegalDocumentAccessLevelService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultLegalDocumentAccessLevelServiceBatch
    extends
    BatchFluentHelperBasic<LegalDocumentAccessLevelServiceBatch, LegalDocumentAccessLevelServiceBatchChangeSet>
    implements
    LegalDocumentAccessLevelServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultLegalDocumentAccessLevelServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalDocumentAccessLevelServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultLegalDocumentAccessLevelServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalDocumentAccessLevelServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultLegalDocumentAccessLevelServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LegalDocumentAccessLevelServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultLegalDocumentAccessLevelServiceBatchChangeSet(this, service);
    }

}
