/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link LegalDocumentAccessLevelServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService
 * LegalDocumentAccessLevelService}.
 *
 */
public class DefaultLegalDocumentAccessLevelServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<LegalDocumentAccessLevelServiceBatch, LegalDocumentAccessLevelServiceBatchChangeSet>
    implements
    LegalDocumentAccessLevelServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService service;

    @SuppressWarnings( "deprecation" )
    DefaultLegalDocumentAccessLevelServiceBatchChangeSet(
        @Nonnull final DefaultLegalDocumentAccessLevelServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentAccessLevelService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultLegalDocumentAccessLevelServiceBatchChangeSet getThis()
    {
        return this;
    }

}
