/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl
 * LglCntntMAccessLvl}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.field.LglCntntMAccessLvlField
 * LglCntntMAccessLvlField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.link.LglCntntMAccessLvlLink
 * LglCntntMAccessLvlLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl#LGL_CNTNT_M_ACCESS_LVL
 * LGL_CNTNT_M_ACCESS_LVL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvl#TO_ACCESS_LEVEL_TEXT
 * TO_ACCESS_LEVEL_TEXT}</li>
 * </ul>
 *
 */
public interface LglCntntMAccessLvlSelectable extends EntitySelectable<LglCntntMAccessLvl>
{

}
