/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlText
 * LglCntntMAccessLvlText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.field.LglCntntMAccessLvlTextField
 * LglCntntMAccessLvlTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.link.LglCntntMAccessLvlTextLink
 * LglCntntMAccessLvlTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlText#LGL_CNTNT_M_ACCESS_LVL
 * LGL_CNTNT_M_ACCESS_LVL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentaccesslevel.LglCntntMAccessLvlText#LGL_CNTNT_M_ACCESS_LVL_NAME
 * LGL_CNTNT_M_ACCESS_LVL_NAME}</li>
 * </ul>
 *
 */
public interface LglCntntMAccessLvlTextSelectable extends EntitySelectable<LglCntntMAccessLvlText>
{

}
