/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.field.LglCntntMDocContentTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.link.LglCntntMDocContentTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.selectable.LglCntntMDocContentTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Legal Document Content Types
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglCntntMDocContentTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglCntntMDocContentType extends VdmEntity<LglCntntMDocContentType>
{

    /**
     * Selector for all available fields of LglCntntMDocContentType.
     *
     */
    public final static LglCntntMDocContentTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocContentType</b>
     * </p>
     *
     * @return Document Content Type
     */
    @Key
    @SerializedName( "LglCntntMDocContentType" )
    @JsonProperty( "LglCntntMDocContentType" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocContentType" )
    private String lglCntntMDocContentType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocContentType</b> field to query operations.
     *
     */
    public final static LglCntntMDocContentTypeField<String> LGL_CNTNT_M_DOC_CONTENT_TYPE =
        new LglCntntMDocContentTypeField<String>("LglCntntMDocContentType");
    /**
     * Navigation property <b>to_LglCntntMDocContentTypeText</b> for <b>LglCntntMDocContentType</b> to multiple
     * <b>LglCntntMDocContentTypeText</b>.
     *
     */
    @SerializedName( "to_LglCntntMDocContentTypeText" )
    @JsonProperty( "to_LglCntntMDocContentTypeText" )
    @ODataField( odataName = "to_LglCntntMDocContentTypeText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LglCntntMDocContentTypeText> toLglCntntMDocContentTypeText;
    /**
     * Use with available fluent helpers to apply the <b>to_LglCntntMDocContentTypeText</b> navigation property to query
     * operations.
     *
     */
    public final static LglCntntMDocContentTypeLink<LglCntntMDocContentTypeText> TO_LGL_CNTNT_M_DOC_CONTENT_TYPE_TEXT =
        new LglCntntMDocContentTypeLink<LglCntntMDocContentTypeText>("to_LglCntntMDocContentTypeText");

    @Nonnull
    @Override
    public Class<LglCntntMDocContentType> getType()
    {
        return LglCntntMDocContentType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocContentType</b>
     * </p>
     *
     * @param lglCntntMDocContentType
     *            Document Content Type
     */
    public void setLglCntntMDocContentType( @Nullable final String lglCntntMDocContentType )
    {
        rememberChangedField("LglCntntMDocContentType", this.lglCntntMDocContentType);
        this.lglCntntMDocContentType = lglCntntMDocContentType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglCntntMDocContentType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMDocContentType", getLglCntntMDocContentType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMDocContentType", getLglCntntMDocContentType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMDocContentType") ) {
                final Object value = values.remove("LglCntntMDocContentType");
                if( (value == null) || (!value.equals(getLglCntntMDocContentType())) ) {
                    setLglCntntMDocContentType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LglCntntMDocContentTypeText") ) {
                final Object value = (values).remove("to_LglCntntMDocContentTypeText");
                if( value instanceof Iterable ) {
                    if( toLglCntntMDocContentTypeText == null ) {
                        toLglCntntMDocContentTypeText = Lists.newArrayList();
                    } else {
                        toLglCntntMDocContentTypeText = Lists.newArrayList(toLglCntntMDocContentTypeText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LglCntntMDocContentTypeText entity;
                        if( toLglCntntMDocContentTypeText.size() > i ) {
                            entity = toLglCntntMDocContentTypeText.get(i);
                        } else {
                            entity = new LglCntntMDocContentTypeText();
                            toLglCntntMDocContentTypeText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LglCntntMDocContentTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LglCntntMDocContentTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglCntntMDocContentTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglCntntMDocContentTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLglCntntMDocContentTypeText != null ) {
            (values).put("to_LglCntntMDocContentTypeText", toLglCntntMDocContentTypeText);
        }
        return values;
    }

    /**
     * Fetches the <b>LglCntntMDocContentTypeText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_LglCntntMDocContentTypeText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LglCntntMDocContentTypeText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglCntntMDocContentTypeText> fetchLglCntntMDocContentTypeText()
    {
        return fetchFieldAsList("to_LglCntntMDocContentTypeText", LglCntntMDocContentTypeText.class);
    }

    /**
     * Retrieval of associated <b>LglCntntMDocContentTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglCntntMDocContentTypeText</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocContentTypeText</b> of a queried <b>LglCntntMDocContentType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LglCntntMDocContentTypeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LglCntntMDocContentTypeText> getLglCntntMDocContentTypeTextOrFetch()
    {
        if( toLglCntntMDocContentTypeText == null ) {
            toLglCntntMDocContentTypeText = fetchLglCntntMDocContentTypeText();
        }
        return toLglCntntMDocContentTypeText;
    }

    /**
     * Retrieval of associated <b>LglCntntMDocContentTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglCntntMDocContentTypeText</b>.
     * <p>
     * If the navigation property for an entity <b>LglCntntMDocContentType</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglCntntMDocContentTypeText</b> is already loaded, the
     *         result will contain the <b>LglCntntMDocContentTypeText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LglCntntMDocContentTypeText>> getLglCntntMDocContentTypeTextIfPresent()
    {
        return Option.of(toLglCntntMDocContentTypeText);
    }

    /**
     * Overwrites the list of associated <b>LglCntntMDocContentTypeText</b> entities for the loaded navigation property
     * <b>to_LglCntntMDocContentTypeText</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocContentTypeText</b> of a queried <b>LglCntntMDocContentType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LglCntntMDocContentTypeText</b> entities.
     */
    public void setLglCntntMDocContentTypeText( @Nonnull final List<LglCntntMDocContentTypeText> value )
    {
        if( toLglCntntMDocContentTypeText == null ) {
            toLglCntntMDocContentTypeText = Lists.newArrayList();
        }
        toLglCntntMDocContentTypeText.clear();
        toLglCntntMDocContentTypeText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LglCntntMDocContentTypeText</b> entities. This corresponds to the
     * OData navigation property <b>to_LglCntntMDocContentTypeText</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocContentTypeText</b> of a queried <b>LglCntntMDocContentType</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LglCntntMDocContentTypeText</b> entities.
     */
    public void addLglCntntMDocContentTypeText( LglCntntMDocContentTypeText... entity )
    {
        if( toLglCntntMDocContentTypeText == null ) {
            toLglCntntMDocContentTypeText = Lists.newArrayList();
        }
        toLglCntntMDocContentTypeText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LglCntntMDocContentType instances.
     *
     */
    public final static class LglCntntMDocContentTypeBuilder
    {

        private List<LglCntntMDocContentTypeText> toLglCntntMDocContentTypeText = Lists.newArrayList();

        private LglCntntMDocContentType.LglCntntMDocContentTypeBuilder toLglCntntMDocContentTypeText(
            final List<LglCntntMDocContentTypeText> value )
        {
            toLglCntntMDocContentTypeText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglCntntMDocContentTypeText</b> for <b>LglCntntMDocContentType</b> to multiple
         * <b>LglCntntMDocContentTypeText</b>.
         *
         * @param value
         *            The LglCntntMDocContentTypeTexts to build this LglCntntMDocContentType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LglCntntMDocContentType.LglCntntMDocContentTypeBuilder lglCntntMDocContentTypeText(
            LglCntntMDocContentTypeText... value )
        {
            return toLglCntntMDocContentTypeText(Lists.newArrayList(value));
        }

    }

}
