/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.field.LglCntntMDocContentTypeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.selectable.LglCntntMDocContentTypeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Content Type - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_LglCntntMDocContentTypeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LglCntntMDocContentTypeText extends VdmEntity<LglCntntMDocContentTypeText>
{

    /**
     * Selector for all available fields of LglCntntMDocContentTypeText.
     *
     */
    public final static LglCntntMDocContentTypeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocContentType</b>
     * </p>
     *
     * @return Document Content Type
     */
    @Key
    @SerializedName( "LglCntntMDocContentType" )
    @JsonProperty( "LglCntntMDocContentType" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocContentType" )
    private String lglCntntMDocContentType;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocContentType</b> field to query operations.
     *
     */
    public final static LglCntntMDocContentTypeTextField<String> LGL_CNTNT_M_DOC_CONTENT_TYPE =
        new LglCntntMDocContentTypeTextField<String>("LglCntntMDocContentType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static LglCntntMDocContentTypeTextField<String> LANGUAGE =
        new LglCntntMDocContentTypeTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocContentTypeName</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "LglCntntMDocContentTypeName" )
    @JsonProperty( "LglCntntMDocContentTypeName" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocContentTypeName" )
    private String lglCntntMDocContentTypeName;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocContentTypeName</b> field to query operations.
     *
     */
    public final static LglCntntMDocContentTypeTextField<String> LGL_CNTNT_M_DOC_CONTENT_TYPE_NAME =
        new LglCntntMDocContentTypeTextField<String>("LglCntntMDocContentTypeName");

    @Nonnull
    @Override
    public Class<LglCntntMDocContentTypeText> getType()
    {
        return LglCntntMDocContentTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocContentType</b>
     * </p>
     *
     * @param lglCntntMDocContentType
     *            Document Content Type
     */
    public void setLglCntntMDocContentType( @Nullable final String lglCntntMDocContentType )
    {
        rememberChangedField("LglCntntMDocContentType", this.lglCntntMDocContentType);
        this.lglCntntMDocContentType = lglCntntMDocContentType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocContentTypeName</b>
     * </p>
     *
     * @param lglCntntMDocContentTypeName
     *            Long Text
     */
    public void setLglCntntMDocContentTypeName( @Nullable final String lglCntntMDocContentTypeName )
    {
        rememberChangedField("LglCntntMDocContentTypeName", this.lglCntntMDocContentTypeName);
        this.lglCntntMDocContentTypeName = lglCntntMDocContentTypeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_LglCntntMDocContentTypeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LglCntntMDocContentType", getLglCntntMDocContentType());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LglCntntMDocContentType", getLglCntntMDocContentType());
        values.put("Language", getLanguage());
        values.put("LglCntntMDocContentTypeName", getLglCntntMDocContentTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LglCntntMDocContentType") ) {
                final Object value = values.remove("LglCntntMDocContentType");
                if( (value == null) || (!value.equals(getLglCntntMDocContentType())) ) {
                    setLglCntntMDocContentType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocContentTypeName") ) {
                final Object value = values.remove("LglCntntMDocContentTypeName");
                if( (value == null) || (!value.equals(getLglCntntMDocContentTypeName())) ) {
                    setLglCntntMDocContentTypeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LglCntntMDocContentTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new LglCntntMDocContentTypeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LglCntntMDocContentTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LglCntntMDocContentTypeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService.DEFAULT_SERVICE_PATH);
    }

}
