/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.selectable.LglCntntMDocContentTypeTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeText
 * LglCntntMDocContentTypeText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class LglCntntMDocContentTypeTextByKeyFluentHelper
    extends
    FluentHelperByKey<LglCntntMDocContentTypeTextByKeyFluentHelper, LglCntntMDocContentTypeText, LglCntntMDocContentTypeTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeText
     * LglCntntMDocContentTypeText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LglCntntMDocContentTypeText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code LglCntntMDocContentTypeText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param lglCntntMDocContentType
     *            Document Content Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public LglCntntMDocContentTypeTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String lglCntntMDocContentType,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("LglCntntMDocContentType", lglCntntMDocContentType);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<LglCntntMDocContentTypeText> getEntityClass()
    {
        return LglCntntMDocContentTypeText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
