/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link LegalDocumentContentTypeServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService
 * LegalDocumentContentTypeService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultLegalDocumentContentTypeServiceBatch
    extends
    BatchFluentHelperBasic<LegalDocumentContentTypeServiceBatch, LegalDocumentContentTypeServiceBatchChangeSet>
    implements
    LegalDocumentContentTypeServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultLegalDocumentContentTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalDocumentContentTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultLegalDocumentContentTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalDocumentContentTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultLegalDocumentContentTypeServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LegalDocumentContentTypeServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultLegalDocumentContentTypeServiceBatchChangeSet(this, service);
    }

}
