/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link LegalDocumentContentTypeServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService
 * LegalDocumentContentTypeService}.
 *
 */
public class DefaultLegalDocumentContentTypeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<LegalDocumentContentTypeServiceBatch, LegalDocumentContentTypeServiceBatchChangeSet>
    implements
    LegalDocumentContentTypeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService service;

    @SuppressWarnings( "deprecation" )
    DefaultLegalDocumentContentTypeServiceBatchChangeSet(
        @Nonnull final DefaultLegalDocumentContentTypeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentContentTypeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultLegalDocumentContentTypeServiceBatchChangeSet getThis()
    {
        return this;
    }

}
