/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentType;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentType
 * LglCntntMDocContentType}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.field.LglCntntMDocContentTypeField
 * LglCntntMDocContentTypeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.link.LglCntntMDocContentTypeLink
 * LglCntntMDocContentTypeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentType#LGL_CNTNT_M_DOC_CONTENT_TYPE
 * LGL_CNTNT_M_DOC_CONTENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentType#TO_LGL_CNTNT_M_DOC_CONTENT_TYPE_TEXT
 * TO_LGL_CNTNT_M_DOC_CONTENT_TYPE_TEXT}</li>
 * </ul>
 *
 */
public interface LglCntntMDocContentTypeSelectable extends EntitySelectable<LglCntntMDocContentType>
{

}
