/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeText
 * LglCntntMDocContentTypeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.field.LglCntntMDocContentTypeTextField
 * LglCntntMDocContentTypeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.link.LglCntntMDocContentTypeTextLink
 * LglCntntMDocContentTypeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeText#LGL_CNTNT_M_DOC_CONTENT_TYPE
 * LGL_CNTNT_M_DOC_CONTENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentcontenttype.LglCntntMDocContentTypeText#LGL_CNTNT_M_DOC_CONTENT_TYPE_NAME
 * LGL_CNTNT_M_DOC_CONTENT_TYPE_NAME}</li>
 * </ul>
 *
 */
public interface LglCntntMDocContentTypeTextSelectable extends EntitySelectable<LglCntntMDocContentTypeText>
{

}
