/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.field.LegalDocumentStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.link.LegalDocumentStatusLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.selectable.LegalDocumentStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Legal Document Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>LegalDocumentStatusType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LegalDocumentStatus extends VdmEntity<LegalDocumentStatus>
{

    /**
     * Selector for all available fields of LegalDocumentStatus.
     *
     */
    public final static LegalDocumentStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @return Document Status
     */
    @Key
    @SerializedName( "InternalDocumentStatus" )
    @JsonProperty( "InternalDocumentStatus" )
    @Nullable
    @ODataField( odataName = "InternalDocumentStatus" )
    private String internalDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>InternalDocumentStatus</b> field to query operations.
     *
     */
    public final static LegalDocumentStatusField<String> INTERNAL_DOCUMENT_STATUS =
        new LegalDocumentStatusField<String>("InternalDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocStatusName</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "LglCntntMDocStatusName" )
    @JsonProperty( "LglCntntMDocStatusName" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocStatusName" )
    private String lglCntntMDocStatusName;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocStatusName</b> field to query operations.
     *
     */
    public final static LegalDocumentStatusField<String> LGL_CNTNT_M_DOC_STATUS_NAME =
        new LegalDocumentStatusField<String>("LglCntntMDocStatusName");
    /**
     * Navigation property <b>to_LglCntntMDocStatusText</b> for <b>LegalDocumentStatus</b> to multiple
     * <b>LegalDocumentStatusText</b>.
     *
     */
    @SerializedName( "to_LglCntntMDocStatusText" )
    @JsonProperty( "to_LglCntntMDocStatusText" )
    @ODataField( odataName = "to_LglCntntMDocStatusText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<LegalDocumentStatusText> toLglCntntMDocStatusText;
    /**
     * Use with available fluent helpers to apply the <b>to_LglCntntMDocStatusText</b> navigation property to query
     * operations.
     *
     */
    public final static LegalDocumentStatusLink<LegalDocumentStatusText> TO_LGL_CNTNT_M_DOC_STATUS_TEXT =
        new LegalDocumentStatusLink<LegalDocumentStatusText>("to_LglCntntMDocStatusText");

    @Nonnull
    @Override
    public Class<LegalDocumentStatus> getType()
    {
        return LegalDocumentStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @param internalDocumentStatus
     *            Document Status
     */
    public void setInternalDocumentStatus( @Nullable final String internalDocumentStatus )
    {
        rememberChangedField("InternalDocumentStatus", this.internalDocumentStatus);
        this.internalDocumentStatus = internalDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocStatusName</b>
     * </p>
     *
     * @param lglCntntMDocStatusName
     *            Long Text
     */
    public void setLglCntntMDocStatusName( @Nullable final String lglCntntMDocStatusName )
    {
        rememberChangedField("LglCntntMDocStatusName", this.lglCntntMDocStatusName);
        this.lglCntntMDocStatusName = lglCntntMDocStatusName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "LegalDocumentStatus";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InternalDocumentStatus", getInternalDocumentStatus());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InternalDocumentStatus", getInternalDocumentStatus());
        values.put("LglCntntMDocStatusName", getLglCntntMDocStatusName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalDocumentStatus") ) {
                final Object value = values.remove("InternalDocumentStatus");
                if( (value == null) || (!value.equals(getInternalDocumentStatus())) ) {
                    setInternalDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocStatusName") ) {
                final Object value = values.remove("LglCntntMDocStatusName");
                if( (value == null) || (!value.equals(getLglCntntMDocStatusName())) ) {
                    setLglCntntMDocStatusName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LglCntntMDocStatusText") ) {
                final Object value = (values).remove("to_LglCntntMDocStatusText");
                if( value instanceof Iterable ) {
                    if( toLglCntntMDocStatusText == null ) {
                        toLglCntntMDocStatusText = Lists.newArrayList();
                    } else {
                        toLglCntntMDocStatusText = Lists.newArrayList(toLglCntntMDocStatusText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        LegalDocumentStatusText entity;
                        if( toLglCntntMDocStatusText.size() > i ) {
                            entity = toLglCntntMDocStatusText.get(i);
                        } else {
                            entity = new LegalDocumentStatusText();
                            toLglCntntMDocStatusText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LegalDocumentStatusField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LegalDocumentStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LegalDocumentStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LegalDocumentStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLglCntntMDocStatusText != null ) {
            (values).put("to_LglCntntMDocStatusText", toLglCntntMDocStatusText);
        }
        return values;
    }

    /**
     * Fetches the <b>LegalDocumentStatusText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_LglCntntMDocStatusText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>LegalDocumentStatusText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LegalDocumentStatusText> fetchLglCntntMDocStatusText()
    {
        return fetchFieldAsList("to_LglCntntMDocStatusText", LegalDocumentStatusText.class);
    }

    /**
     * Retrieval of associated <b>LegalDocumentStatusText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglCntntMDocStatusText</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocStatusText</b> of a queried <b>LegalDocumentStatus</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LegalDocumentStatusText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<LegalDocumentStatusText> getLglCntntMDocStatusTextOrFetch()
    {
        if( toLglCntntMDocStatusText == null ) {
            toLglCntntMDocStatusText = fetchLglCntntMDocStatusText();
        }
        return toLglCntntMDocStatusText;
    }

    /**
     * Retrieval of associated <b>LegalDocumentStatusText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LglCntntMDocStatusText</b>.
     * <p>
     * If the navigation property for an entity <b>LegalDocumentStatus</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglCntntMDocStatusText</b> is already loaded, the result
     *         will contain the <b>LegalDocumentStatusText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<LegalDocumentStatusText>> getLglCntntMDocStatusTextIfPresent()
    {
        return Option.of(toLglCntntMDocStatusText);
    }

    /**
     * Overwrites the list of associated <b>LegalDocumentStatusText</b> entities for the loaded navigation property
     * <b>to_LglCntntMDocStatusText</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocStatusText</b> of a queried <b>LegalDocumentStatus</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>LegalDocumentStatusText</b> entities.
     */
    public void setLglCntntMDocStatusText( @Nonnull final List<LegalDocumentStatusText> value )
    {
        if( toLglCntntMDocStatusText == null ) {
            toLglCntntMDocStatusText = Lists.newArrayList();
        }
        toLglCntntMDocStatusText.clear();
        toLglCntntMDocStatusText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>LegalDocumentStatusText</b> entities. This corresponds to the OData
     * navigation property <b>to_LglCntntMDocStatusText</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocStatusText</b> of a queried <b>LegalDocumentStatus</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>LegalDocumentStatusText</b> entities.
     */
    public void addLglCntntMDocStatusText( LegalDocumentStatusText... entity )
    {
        if( toLglCntntMDocStatusText == null ) {
            toLglCntntMDocStatusText = Lists.newArrayList();
        }
        toLglCntntMDocStatusText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of LegalDocumentStatus instances.
     *
     */
    public final static class LegalDocumentStatusBuilder
    {

        private List<LegalDocumentStatusText> toLglCntntMDocStatusText = Lists.newArrayList();

        private LegalDocumentStatus.LegalDocumentStatusBuilder toLglCntntMDocStatusText(
            final List<LegalDocumentStatusText> value )
        {
            toLglCntntMDocStatusText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LglCntntMDocStatusText</b> for <b>LegalDocumentStatus</b> to multiple
         * <b>LegalDocumentStatusText</b>.
         *
         * @param value
         *            The LegalDocumentStatusTexts to build this LegalDocumentStatus with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalDocumentStatus.LegalDocumentStatusBuilder lglCntntMDocStatusText( LegalDocumentStatusText... value )
        {
            return toLglCntntMDocStatusText(Lists.newArrayList(value));
        }

    }

}
