/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.selectable.LegalDocumentStatusSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus
 * LegalDocumentStatus} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class LegalDocumentStatusByKeyFluentHelper
    extends
    FluentHelperByKey<LegalDocumentStatusByKeyFluentHelper, LegalDocumentStatus, LegalDocumentStatusSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus
     * LegalDocumentStatus} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LegalDocumentStatus}
     * @param internalDocumentStatus
     *            Document Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code LegalDocumentStatus}
     */
    public LegalDocumentStatusByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String internalDocumentStatus )
    {
        super(servicePath, entityCollection);
        this.key.put("InternalDocumentStatus", internalDocumentStatus);
    }

    @Override
    @Nonnull
    protected Class<LegalDocumentStatus> getEntityClass()
    {
        return LegalDocumentStatus.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
