/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.field.LegalDocumentStatusTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.link.LegalDocumentStatusTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.selectable.LegalDocumentStatusTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Legal Document Status - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>LegalDocumentStatusTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class LegalDocumentStatusText extends VdmEntity<LegalDocumentStatusText>
{

    /**
     * Selector for all available fields of LegalDocumentStatusText.
     *
     */
    public final static LegalDocumentStatusTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @return Document Status
     */
    @Key
    @SerializedName( "InternalDocumentStatus" )
    @JsonProperty( "InternalDocumentStatus" )
    @Nullable
    @ODataField( odataName = "InternalDocumentStatus" )
    private String internalDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>InternalDocumentStatus</b> field to query operations.
     *
     */
    public final static LegalDocumentStatusTextField<String> INTERNAL_DOCUMENT_STATUS =
        new LegalDocumentStatusTextField<String>("InternalDocumentStatus");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static LegalDocumentStatusTextField<String> LANGUAGE =
        new LegalDocumentStatusTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocStatusName</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "LglCntntMDocStatusName" )
    @JsonProperty( "LglCntntMDocStatusName" )
    @Nullable
    @ODataField( odataName = "LglCntntMDocStatusName" )
    private String lglCntntMDocStatusName;
    /**
     * Use with available fluent helpers to apply the <b>LglCntntMDocStatusName</b> field to query operations.
     *
     */
    public final static LegalDocumentStatusTextField<String> LGL_CNTNT_M_DOC_STATUS_NAME =
        new LegalDocumentStatusTextField<String>("LglCntntMDocStatusName");
    /**
     * Navigation property <b>to_LglCntntMDocStatus</b> for <b>LegalDocumentStatusText</b> to single
     * <b>LegalDocumentStatus</b>.
     *
     */
    @SerializedName( "to_LglCntntMDocStatus" )
    @JsonProperty( "to_LglCntntMDocStatus" )
    @ODataField( odataName = "to_LglCntntMDocStatus" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private LegalDocumentStatus toLglCntntMDocStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_LglCntntMDocStatus</b> navigation property to query
     * operations.
     *
     */
    public final static LegalDocumentStatusTextOneToOneLink<LegalDocumentStatus> TO_LGL_CNTNT_M_DOC_STATUS =
        new LegalDocumentStatusTextOneToOneLink<LegalDocumentStatus>("to_LglCntntMDocStatus");

    @Nonnull
    @Override
    public Class<LegalDocumentStatusText> getType()
    {
        return LegalDocumentStatusText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @param internalDocumentStatus
     *            Document Status
     */
    public void setInternalDocumentStatus( @Nullable final String internalDocumentStatus )
    {
        rememberChangedField("InternalDocumentStatus", this.internalDocumentStatus);
        this.internalDocumentStatus = internalDocumentStatus;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LglCntntMDocStatusName</b>
     * </p>
     *
     * @param lglCntntMDocStatusName
     *            Long Text
     */
    public void setLglCntntMDocStatusName( @Nullable final String lglCntntMDocStatusName )
    {
        rememberChangedField("LglCntntMDocStatusName", this.lglCntntMDocStatusName);
        this.lglCntntMDocStatusName = lglCntntMDocStatusName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "LegalDocumentStatusText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("InternalDocumentStatus", getInternalDocumentStatus());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("InternalDocumentStatus", getInternalDocumentStatus());
        values.put("Language", getLanguage());
        values.put("LglCntntMDocStatusName", getLglCntntMDocStatusName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("InternalDocumentStatus") ) {
                final Object value = values.remove("InternalDocumentStatus");
                if( (value == null) || (!value.equals(getInternalDocumentStatus())) ) {
                    setInternalDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LglCntntMDocStatusName") ) {
                final Object value = values.remove("LglCntntMDocStatusName");
                if( (value == null) || (!value.equals(getLglCntntMDocStatusName())) ) {
                    setLglCntntMDocStatusName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LglCntntMDocStatus") ) {
                final Object value = (values).remove("to_LglCntntMDocStatus");
                if( value instanceof Map ) {
                    if( toLglCntntMDocStatus == null ) {
                        toLglCntntMDocStatus = new LegalDocumentStatus();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toLglCntntMDocStatus.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> LegalDocumentStatusTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LegalDocumentStatusTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LegalDocumentStatusTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LegalDocumentStatusTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLglCntntMDocStatus != null ) {
            (values).put("to_LglCntntMDocStatus", toLglCntntMDocStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>LegalDocumentStatus</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_LglCntntMDocStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>LegalDocumentStatus</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LegalDocumentStatus fetchLglCntntMDocStatus()
    {
        return fetchFieldAsSingle("to_LglCntntMDocStatus", LegalDocumentStatus.class);
    }

    /**
     * Retrieval of associated <b>LegalDocumentStatus</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_LglCntntMDocStatus</b>.
     * <p>
     * If the navigation property <b>to_LglCntntMDocStatus</b> of a queried <b>LegalDocumentStatusText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>LegalDocumentStatus</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public LegalDocumentStatus getLglCntntMDocStatusOrFetch()
    {
        if( toLglCntntMDocStatus == null ) {
            toLglCntntMDocStatus = fetchLglCntntMDocStatus();
        }
        return toLglCntntMDocStatus;
    }

    /**
     * Retrieval of associated <b>LegalDocumentStatus</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_LglCntntMDocStatus</b>.
     * <p>
     * If the navigation property for an entity <b>LegalDocumentStatusText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LglCntntMDocStatus</b> is already loaded, the result
     *         will contain the <b>LegalDocumentStatus</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<LegalDocumentStatus> getLglCntntMDocStatusIfPresent()
    {
        return Option.of(toLglCntntMDocStatus);
    }

    /**
     * Overwrites the associated <b>LegalDocumentStatus</b> entity for the loaded navigation property
     * <b>to_LglCntntMDocStatus</b>.
     *
     * @param value
     *            New <b>LegalDocumentStatus</b> entity.
     */
    public void setLglCntntMDocStatus( final LegalDocumentStatus value )
    {
        toLglCntntMDocStatus = value;
    }

    /**
     * Helper class to allow for fluent creation of LegalDocumentStatusText instances.
     *
     */
    public final static class LegalDocumentStatusTextBuilder
    {

        private LegalDocumentStatus toLglCntntMDocStatus;

        private LegalDocumentStatusText.LegalDocumentStatusTextBuilder toLglCntntMDocStatus(
            final LegalDocumentStatus value )
        {
            toLglCntntMDocStatus = value;
            return this;
        }

        /**
         * Navigation property <b>to_LglCntntMDocStatus</b> for <b>LegalDocumentStatusText</b> to single
         * <b>LegalDocumentStatus</b>.
         *
         * @param value
         *            The LegalDocumentStatus to build this LegalDocumentStatusText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public LegalDocumentStatusText.LegalDocumentStatusTextBuilder lglCntntMDocStatus(
            final LegalDocumentStatus value )
        {
            return toLglCntntMDocStatus(value);
        }

    }

}
