/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link LegalDocumentStatusServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService LegalDocumentStatusService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultLegalDocumentStatusServiceBatch
    extends
    BatchFluentHelperBasic<LegalDocumentStatusServiceBatch, LegalDocumentStatusServiceBatchChangeSet>
    implements
    LegalDocumentStatusServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultLegalDocumentStatusServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalDocumentStatusServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultLegalDocumentStatusServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultLegalDocumentStatusServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultLegalDocumentStatusServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public LegalDocumentStatusServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultLegalDocumentStatusServiceBatchChangeSet(this, service);
    }

}
