/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link LegalDocumentStatusServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService LegalDocumentStatusService}.
 *
 */
public class DefaultLegalDocumentStatusServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<LegalDocumentStatusServiceBatch, LegalDocumentStatusServiceBatchChangeSet>
    implements
    LegalDocumentStatusServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService service;

    @SuppressWarnings( "deprecation" )
    DefaultLegalDocumentStatusServiceBatchChangeSet(
        @Nonnull final DefaultLegalDocumentStatusServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.LegalDocumentStatusService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultLegalDocumentStatusServiceBatchChangeSet getThis()
    {
        return this;
    }

}
