/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus
 * LegalDocumentStatus}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.field.LegalDocumentStatusField
 * LegalDocumentStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.link.LegalDocumentStatusLink
 * LegalDocumentStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus#INTERNAL_DOCUMENT_STATUS
 * INTERNAL_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus#LGL_CNTNT_M_DOC_STATUS_NAME
 * LGL_CNTNT_M_DOC_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.legaldocumentstatus.LegalDocumentStatus#TO_LGL_CNTNT_M_DOC_STATUS_TEXT
 * TO_LGL_CNTNT_M_DOC_STATUS_TEXT}</li>
 * </ul>
 *
 */
public interface LegalDocumentStatusSelectable extends EntitySelectable<LegalDocumentStatus>
{

}
